/* sqlqueryedit.h
 *
 * Copyright (C) 1999, 2000 Vivien Malerba
 * Copyright (C) 2001 Fernando Martins
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __SQL_QUERY_EDIT__
#define __SQL_QUERY_EDIT__

#include <gnome.h>
#include "sqlquery.h"
#include "gasql_conf.h"
#include "sqlwiddbtree.h"
#include "sqlwiddbrel.h"
#include "condlist.h"

#ifdef __cplusplus
extern "C"
{
#endif				/* __cplusplus */

#define SQL_QUERY_EDIT(obj)          GTK_CHECK_CAST (obj, sql_query_edit_get_type(), SqlQueryEdit)
#define SQL_QUERY_EDIT_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_query_edit_get_type (), SqlQueryEditClass)
#define IS_SQL_QUERY_EDIT(obj)       GTK_CHECK_TYPE (obj, sql_query_edit_get_type ())


	typedef struct _SqlQueryEdit SqlQueryEdit;
	typedef struct _SqlQueryEditClass SqlQueryEditClass;

	/* struct for the object's data */
	struct _SqlQueryEdit
	{
		GtkVBox object;

		SqlQuery *q;

		/* name and description entries */
		GtkWidget *name;
		GtkWidget *descr;

		/* main widgets */
		GtkWidget *tree;
		GtkWidget *relview;
		GtkWidget *notebook;

		SqlMemTable *sel_table;

		/* Objects notebook page */
		GtkWidget *clist;
		GtkWidget *add_button;
		GtkWidget *edit_button;
		GtkWidget *del_button;	/* to delete the selected field */
		GtkWidget *obj_add_dlg;	/* dialog to add a new object */
		GSList *edited_objects;	/* list of objects currently being edited 
					   (not new objects!) */
		/* Join page */
		GtkWidget *depend_clist;
		GSList *group_join_type; /* Group with radio buttons for Join Type */
		GtkWidget *frame_join_type; /* Frame box for Join Type */
		GtkWidget *join_options[LAST_JOIN_TYPE]; /* Option buttons for Join Type group */
		gint depend_sel;

		/* Where notebook page */
		GtkWidget *cdlist;
		GHashTable *h_modif_dlg;	/* key=GNode value=GnomeDialog for modif if there is */

		/* Options notebook page */
		GtkWidget *ordersel;
		GtkWidget *orderlist;
		GtkWidget *groupsel;
		GtkWidget *grouplist;
		GtkWidget *cond_add_dlg;	/* dialog to add WHERE conditions */
		GtkWidget *wh_modif_button;
		GtkWidget *wh_del_button;

		/* Text notebook page */
		GtkWidget *text;
		GtkWidget *texttoggle;
		GtkWidget *text_valid_btn;

		SqlMemField *selection;	/* to be added if "ADD" button clicked */
	};

	/* struct for the object's class */
	struct _SqlQueryEditClass
	{
		GtkVBoxClass parent_class;
	};

	/* 
	 * generic widget's functions 
	 */
	guint sql_query_edit_get_type (void);
	GtkWidget *sql_query_edit_new (SqlQuery * q);

	/* 
	 * Creates a GnomeDialog with a query edit widget inside 
	 */
	GtkWidget *sql_query_edit_new_dlg (SqlQuery * q);

#ifdef __cplusplus
}
#endif				/* __cplusplus */

#endif
