
/* Gnome BibTeX gbib.h
 *    Copyright 1998 Alejandro Aguilar Sierra <asierra@servidor.unam.mx>
 * 
 *    This program is free software; you can redistribute it and'or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2, or (at your option)
 *    any later version.
 */

#ifndef _GBIB_H
#define _GBIB_H

#include <std/bastring.h>
#include <vector>
#include <slist>
#include <stack>

// it's very important that config.h is called before gnome.h,
// to define ENABLE_NLS if needed
#include "config.h"

#include <gnome.h>


typedef basic_string <char> string;
typedef pair<int, string> pair_string;
typedef vector<string> vector_string;
typedef slist<pair_string> slist_pair_string;
typedef pair<string, string> pair_strings;
typedef vector<pair_strings> vector_pair_strings;

// entrydef.C
class BibEntryDef
{
 public:
    int nreq, nopt;
    string name;
    int *required;
    int *optional;
    
    char *getRequired(int);
    char *getOptional(int);
    int getFieldIdx(char *);
    
    ~BibEntryDef() { 
	delete[] required;
	delete[] optional;
    }
};



typedef enum {
  BRACE, QUOTE, PAREN
} Delimiter;

// bibentry.C
class BibEntry {
 public:
    
    ///
    BibEntry();
    ///
    BibEntry(char *entrytype, const char *key);
    /// Copy constructor
    BibEntry(BibEntry&);
    ///
    ~BibEntry();
    
    const char *getEntryType() const;
    const char *getKey() const;
    char *getFieldName(int);

    const char *getField(int) const;
    const char *getField(char*) const;

    char *getReqField(int);
    char *getOptField(int);
    char *getExtField(int);
    
    int getNoFields() {
	return (!def) ? 1:  def->nreq + def->nopt + nextra;
    }
    
    int getNoReqFields() {
	return (!def) ? 1: def->nreq;
    }
    
    int getNoOptFields() {
	return (!def) ? 0: def->nopt;
    }
    
    int getNoExtraFields() {
	return nextra;
    }
    
    void setEntryType(char *);
    
    void setKey(char *k) { key = k; }
    
    void setField(int, char *);
    
    void setField(char * fieldname, char *);

    void setFields(BibEntry &);
    
    BibEntry& operator=(BibEntry &);
    
    bool isSpecial() { return special; }
    
    void allowExtraField() { allow_extra = true; }
    
 protected:
    string key;
    string *req_field;
    string *opt_field;
    BibEntryDef *def;
    int nextra;    
    slist_pair_string extra_field;
    bool special;
    bool allow_extra;
    friend class BibentryTable;
};


typedef BibEntryDef* ApBibEntryDef;

typedef BibEntry* ApBibEntry;

void new_entrydef(char* name, char* required, char* optional);
void new_bibstyles(char*);
void new_commands(char*);
bool isCommand(char *n);

BibEntryDef *getBibEntryDef(char *);

char *get_entrytype_name(int);

int set_globalfield_name(char *);
char *get_globalfield_name(int);

char *get_bibtex_style(int);

void update_entry(bool is_new=false);

typedef BibEntry* ApBibEntry;
typedef vector<ApBibEntry> EntryTab;

typedef enum {
  Ask,
  IgnoreNew,
  IgnoreNewAlways,
  ReplaceOld,
  ReplaceOldAlways,
  AutoFix,
  AutoFixAlways
} ResponseType;


// bibfiles.C + entrylist.C
class BibentryTable {
 public:
    BibentryTable();
    ~BibentryTable();
    void resetUI();
    void clear();
    void new_entry(BibEntry&);
    void insert_entry(BibEntry&, int);
    /// True if the key is new, False otherwise
    bool replace_entry(BibEntry&, int idx=-1);
    void delete_entry(int);
    BibEntry *get_entry(int);
    int readBibfile(char *);
    int writeBibfile(const char *);
    int writeBibfile2(char *);
    int search_key(const char *s); 
    int search_string(char *, int first=0);
    void sort(int ascending, char *s = "key");
    
    string dbname;
    int selected_entry;
    int size() { return entryTab.size(); }
    
    // Command handling
    void new_command(string, string);
    pair_strings getCommand(int);
    void delCommand(int);
    void setCommand(int, string);
    int commandSize() {
       return commands.size();
    }
 private:
    static EntryTab entryTab;
    ResponseType  conflict;
    vector_pair_strings commands;
};


#endif
