import settings

from GConfBackend import GConfBackend as Backend


class _ConfigManager(Backend):

    """Class for managing configuration."""

    def __init__(self):

        Backend.__init__(self)

        # hashtable for config change handlers: path -> handler
        self.__handlers = {}

        self.add_observer(self.__on_observe_backend)



    def __on_observe_backend(self, src, cmd, *args):

        if (cmd == src.OBS_UPDATE):
            path, value = args

            for i in xrange(len(path)):
                handler = self.__handlers.get(tuple(path[:i + 1]))
                if (handler):
                    handler(path, value)
                    break
            #end for




    def watch(self, *args):

        """Sets a callback handler for watching changes for the given
        configuration entry."""

        path, handler = args[:-1], args[-1]
        self.__handlers[path] = handler



    def remove_watcher(self, *args):

        """Removes a watch callback handler."""

        try:
            path = args[:-1]
            del self.__handlers[path]
        except KeyError:
            pass



    def clear(self, *path):

        """Clears an ID entry in the configuration backend."""

        entries = self.list(*path)
        if (not entries):
            Backend.clear(self, *path)
        else:
            for e in entries:
                self.clear( * list(path) + [e] )



    def copy(self, src, dest):

        """Recursively copies a configuration node."""

        for d in self.list(*src):
            self.copy(src + [d], dest + [src[-1], d])

        value = self.get(*src)
        if (value): self.set( * dest + [value] )


_singleton = _ConfigManager()
def ConfigManager(): return _singleton
