/****************************************************************************
** userinfo.h
**
** Michael S. Borella <mike@borella.net>
**
** Class definition for UNIX information on the user (caller)
**
*****************************************************************************/

#ifndef USERINFO_H
#define USERINFO_H

#include <string>
#include "eh_system.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

//---------------------------------------------------------------------------
//
// class Userinfo
//
//---------------------------------------------------------------------------

class Userinfo
{
private:
  string _userid;
  string _username;
  string _hostname;
  string _domainname;

public:
  // Constructor and destructor
  Userinfo() throw(EH_system);
  ~Userinfo(){}

  // functions to retrieve the values
  string userid()        { return _userid; }
  string username()      { return _username; }
  string hostname()      { return _hostname; }
  string domainname()    { return _domainname; }

  // format the output into "userid@host (name)"
  string format() { return _userid + "@" + _hostname + _domainname + 
		      " (" + _username + ")"; }
};

#endif



