/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  hypertext.cc - AtkHypertext C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "hypertext.hh"
#include "private/marshal.hh"
#include "hyperlink.hh"

using namespace GFC;

/*  Atk::Hypertext
 */

Atk::Hypertext::Hypertext()
{
}
	
Atk::Hypertext::~Hypertext()
{
}
	
Atk::Hyperlink*
Atk::Hypertext::get_link(int link_index) const
{
	AtkHyperlink *hyperlink = atk_hypertext_get_link(atk_hypertext(), link_index);
	return hyperlink ? G::Object::wrap<Hyperlink>(hyperlink) : 0;
}

/*  Atk::Hypertext signals
 */

const Atk::Hypertext::LinkSelectedSignalType Atk::Hypertext::link_selected_signal("link_selected", (GCallback)&G::Marshal::void_int_callback);

