/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  selection.inl - Gtk::SelectionData, Gtk::TargetEntry and Gtk::TargetList inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*  Gtk::SelectionData
 */

inline GtkSelectionData*
GFC::Gtk::SelectionData::gtk_selection_data() const
{
	return reinterpret_cast<GtkSelectionData*>(boxed_);
}

inline bool
GFC::Gtk::SelectionData::is_valid() const
{
	return gtk_selection_data()->length >= 0;
}

inline GFC::Gdk::Atom
GFC::Gtk::SelectionData::selection() const
{
	return gtk_selection_data()->selection;
}

inline GFC::Gdk::Atom
GFC::Gtk::SelectionData::target() const
{
	return gtk_selection_data()->target;
}

inline GFC::Gdk::Atom
GFC::Gtk::SelectionData::type() const
{
	return gtk_selection_data()->type;
}

inline int
GFC::Gtk::SelectionData::format() const
{
	return gtk_selection_data()->format;
}

inline unsigned char*
GFC::Gtk::SelectionData::data() const
{
	return gtk_selection_data()->data;
}

inline int
GFC::Gtk::SelectionData::length() const
{
	return gtk_selection_data()->length;
}

inline void
GFC::Gtk::SelectionData::set(Gdk::Atom type, int format, const void *data, int length)
{
	gtk_selection_data_set(gtk_selection_data(), type, format, static_cast<const guchar*>(data), length);
}

inline bool
GFC::Gtk::SelectionData::set_text(const char *str)
{
	return gtk_selection_data_set_text(gtk_selection_data(), str, -1);
}

inline bool
GFC::Gtk::SelectionData::targets_include_text() const
{
	return gtk_selection_data_targets_include_text(gtk_selection_data());
}

/*  Gtk::TargetEntry
 */

inline GtkTargetEntry*
GFC::Gtk::TargetEntry::gtk_target_entry() const
{
	return const_cast<GtkTargetEntry*>(&entry_);
}

inline const char*
GFC::Gtk::TargetEntry::target() const
{
	return entry_.target;
}

inline unsigned int
GFC::Gtk::TargetEntry::flags() const
{
	return entry_.flags;
}

inline unsigned int
GFC::Gtk::TargetEntry::info() const
{
	return entry_.info;
}

/*  Gtk::TargetList
 */

inline GtkTargetList*
GFC::Gtk::TargetList::gtk_target_list() const
{
	return target_list_;
}

inline GFC::Gtk::TargetList::operator GtkTargetList* () const
{
	return this ? target_list_ : 0;
}

inline void
GFC::Gtk::TargetList::remove(Gdk::Atom target)
{
	gtk_target_list_remove(target_list_, target);
}

inline bool
GFC::Gtk::TargetList::find(Gdk::Atom target, unsigned int *info)
{
	return gtk_target_list_find(target_list_, target, info);
}

