/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __UI_BROWSE_H__
#define __UI_BROWSE_H__

#include <gtk/gtk.h>

#include "ui_child.h"

/*
  GiftuiChild
      +----GiftuiBrowse
*/

#define GIFTUI_TYPE_BROWSE (giftui_browse_get_type ())
#define GIFTUI_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIFTUI_TYPE_BROWSE, GiftuiBrowse))
#define GIFTUI_BROWSE_CLASS(class) (G_TYPE_CHECK_CLASS_CAST ((class), GIFTUI_TYPE_BROWSE, GiftuiBrowseClass))
#define GIFTUI_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIFTUI_TYPE_BROWSE))
#define GIFTUI_IS_BROWSE_CLASS(class) (G_TYPE_CHECK_CLASS_TYPE ((class), GIFTUI_TYPE_BROWSE))
#define GIFTUI_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GIFTUI_TYPE_BROWSE, GiftuiBrowseClass))

typedef struct _GiftuiBrowse GiftuiBrowse;
typedef struct _GiftuiBrowseClass GiftuiBrowseClass;

struct _GiftuiBrowse
{
	GiftuiChild parent_instance;
	
	/* < private data > */
	GtkWidget *refresh;
	GtkWidget *stop;
	
	GtkWidget *entry; /* User */
	GtkWidget *icon;
	GtkWidget *stats; /* stats */
	
	GtkWidget *list;  /* Where we put results */
	GtkWidget *popup; /* Popup menu */
	
	guint id;
	gchar *user;
	guint files;
};

struct _GiftuiBrowseClass
{
	GiftuiChildClass parent_class;
};

GType giftui_browse_get_type (void);
GtkWidget *giftui_browse_new (const gchar *user);

#endif
