#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef ENABLE_NLS
#include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
#else
#define _(str) str
#define N_(str) str
#endif

#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netinet/tcp.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <getopt.h>

#include <glib/gprintf.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include <gdk/gdkkeysyms.h>

#include "libmpdclient.h"

#include "structs.h"

#include "comm.h"
#include "conf.h"
#include "gui.h"
#include "support.h"
#include "player.h"

#define GLURP_TITLE_PREFIX	"Glurp v"GLURP_VERSION

#define GLURP_CONFIG_FILE	".glurp"

#define NUM_SETTINGS		50

#define MPD_PORT		6600

#define MIN_REFRESH_RATE	100
#define MAX_REFRESH_RATE	10000

#define MAX_STREAM_HISTORY	5

#define TRACKNAME_SCROLL_START	50

enum {
  GLURP_CONN_STATE_DISCONNECTED,
  GLURP_CONN_STATE_CONNECTING,
  GLURP_CONN_STATE_CONNECTED,
  GLURP_CONN_STATE_DISCONNECTING
};

#define DISCONNECTED	(glurp->conn_state == GLURP_CONN_STATE_DISCONNECTED)
#define CONNECTING	(glurp->conn_state == GLURP_CONN_STATE_CONNECTING)
#define CONNECTED	(glurp->conn_state == GLURP_CONN_STATE_CONNECTED)
#define DISCONNECTING	(glurp->conn_state == GLURP_CONN_STATE_DISCONNECTING)

#define STOPPED		(glurp->play_state == MPD_STATUS_STATE_STOP)
#define PLAYING		(glurp->play_state == MPD_STATUS_STATE_PLAY)
#define PAUSED		(glurp->play_state == MPD_STATUS_STATE_PAUSE)

enum {
  GLURP_STATUSBAR_MAIN,
  GLURP_STATUSBAR_PLAYLISTS
};

enum {
  GLURP_QSEARCH_ALL,
  GLURP_QSEARCH_TITLE,
  GLURP_QSEARCH_ARTIST,
  GLURP_QSEARCH_ALBUM,
  GLURP_QSEARCH_FILENAME,

  NUM_QSEARCH
};
