/******************************************************************************\
 gnofin/dialog-message.c   $Revision: 1.2 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <stdarg.h>
#include <libgnomeui/gnome-dialog.h>
#include <libgnomeui/gnome-messagebox.h>
#include <libgnomeui/gnome-stock.h>
#include "dialogs.h"

void
dialog_message (GtkWindow   *parent,
		const gchar *message_type,
		const gchar *message, ...)
{
  char message_buf[256] = {0};
  GnomeDialog *dialog;
  va_list ap;

  trace ("");

  /* generate message string */
  va_start (ap, message);
  g_vsnprintf (message_buf, 256, message, ap);
  va_end (ap);

  trace ("%s", message_buf);

  dialog = GNOME_DIALOG (gnome_message_box_new (message_buf,
					        message_type,
					        GNOME_STOCK_BUTTON_OK,
					        NULL));
  
  if (parent)
    gnome_dialog_set_parent (dialog, parent);
  else
    gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);

  //gtk_window_set_transient_for (GTK_WINDOW (dialog), parent);

  gnome_dialog_set_default (dialog, 0);
  gnome_dialog_run_and_close (dialog);
}
