/******************************************************************************\
 gnofin/date-preferences-page.c   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

//#define ENABLE_DEBUG_TRACE

#include "common.h"
#include <gtk/gtksignal.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtktable.h>
#include <gtk/gtkspinbutton.h>
#include "preferences.h"
#include "preferences-pages.h"
#include "xml-io.h"
#include "numeric-parser.h"
#include "dialogs.h"

typedef struct {
  gpointer  key;
  GtkEntry *level;
} PageContext;

static void
on_level_changed (GtkEntry *entry, PageContext *page)
{
  preferences_page_changed (page->key);
}

static GtkWidget *
make_page (PageContext *page)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *spin;
  GtkAdjustment *adj;

  trace ("");

  vbox = gtk_vbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);

  /* Page description
   */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  label = gtk_label_new (_("Select the compression level Gnofin should use\nwhen saving files (0 = none)."));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  /* Packing table
   */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  table = gtk_table_new (1, 2, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 10);
  gtk_box_pack_start (GTK_BOX (hbox), table, FALSE, FALSE, 0);

  /* Compression level entry
   */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), hbox, 0, 1, 0, 1);

  label = gtk_label_new (_("Compression level:"));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 20);

  adj = GTK_ADJUSTMENT (gtk_adjustment_new (0.0, 0.0, 9.0, 1.0, 1.0, 0.0));
  spin = gtk_spin_button_new (adj, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spin), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), spin, 1, 2, 0, 1);

  page->level = GTK_ENTRY (spin);
  gtk_signal_connect (GTK_OBJECT (spin), "changed",
  		      GTK_SIGNAL_FUNC (on_level_changed), page);

  /* Disclaimer
   */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  label = gtk_label_new (_("(Note: this option requires that your system has libxml\ncompiled with compression enabled.)"));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  return vbox;
}

static void
init_page (PageContext *page)
{
  gchar *text;

  trace ("");

  text = g_strdup_printf ("%d", xml_io_get_compression_level ());
  gtk_entry_set_text (page->level, text);
  g_free (text);
}

static gboolean
apply_page (GtkWindow *parent, PageContext *page)
{
  guint level;
  const gchar *text;

  trace ("");

  text = (gtk_entry_get_text (page->level));

  if (uint_parse (text, &level))
  {
    xml_io_set_compression_level (level);
    return TRUE;
  }
  else
  {
    dialog_error (parent, _("There was an error parsing the compression level"));
    return FALSE;
  }
}

void
preferences_page_xml_io_init (void)
{
  PreferencesPage page = {0};
  PageContext *context;

  trace ("");

  context = g_new0 (PageContext, 1);

  page.category = _("File");
  page.label = _("Compression");
  page.make = (PreferencesPageMakeFunc) make_page;
  page.init = (PreferencesPageInitFunc) init_page;
  page.apply = (PreferencesPageApplyFunc) apply_page;
  page.user_data = context;
  
  context->key = preferences_page_register (&page);
}
