/*
 * GNoise
 *
 * Copyright (C) 1999-2001 Dwight Engen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: gtkwavedisplay.h,v 1.6 2002/01/13 02:51:16 dengen Exp $
 *
 */

#ifndef __GTK_WAVE_DISPLAY_H__
#define __GTK_WAVE_DISPLAY_H__

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>
#include "snd_buf.h"

#define GTK_TYPE_WAVE_DISPLAY            (gtk_wave_display_get_type ())
#define GTK_WAVE_DISPLAY(obj)            (GTK_CHECK_CAST ((obj), GTK_TYPE_WAVE_DISPLAY, GtkWaveDisplay))
#define GTK_WAVE_DISPLAY_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_WAVE_DISPLAY, GtkWaveDisplayClass))
#define GTK_IS_WAVE_DISPLAY(obj)         (GTK_CHECK_TYPE ((obj), GTK_TYPE_WAVE_DISPLAY))
#define GTK_IS_WAVE_DISPLAY_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_WAVE_DISPLAY))

typedef struct _GtkWaveDisplay       GtkWaveDisplay;
typedef struct _GtkWaveDisplayClass  GtkWaveDisplayClass;

/* custom colors for drawing if not following GTK colors */
enum
{
    WD_COLOR_PLAYLINE,
    WD_COLOR_MARKER_BG,
    WD_COLOR_MARKER_FG,
    WD_COLOR_MARKER_SEL_BG,
    WD_COLOR_MARKER_SEL_FG,
    WD_COLOR_BG,
    WD_COLOR_FG,
    WD_COLOR_SEL_BG,
    WD_COLOR_SEL_FG,
    WD_COLOR_LAST
};



struct _GtkWaveDisplay
{
    GtkWidget	widget;

    /* display */
    snd_buf_t	*snd_buf;		/* data to draw */
    gint8	channel;		/* which channel to draw */
    smpl_indx	start_smpl;		/* first sample drawn in window */
    smpl_indx	play_smpl;		/* where the playline is */
    gint	play_xpix;		/* where the playline is */
    GdkWindow   *play_win;
    smpl_indx	selected_marker;	/* the currently selected marker */
    guint	zoom;			/* zoom level */
    GdkPixmap	*pixmap;
    GdkGC	*color[WD_COLOR_LAST];
    GdkCursor	*cursor;
    gboolean	backing_store;

    /* selection */
    gboolean	selection;		/* if the selection data is valid */
    smpl_indx	selection_start;
    smpl_indx	selection_end;
    smpl_indx	selection_start_old;
    smpl_indx	selection_end_old;
};

struct _GtkWaveDisplayClass
{
    GtkWidgetClass parent_class;
    GdkColor	   colors[WD_COLOR_LAST];
    guint	   color_cnt;
};

GtkType     gtk_wave_display_get_type	(void);
GtkWidget  *gtk_wave_display_new	(void);
void	    gtk_wave_display_snd_set	(GtkWaveDisplay *wd, snd_buf_t *snd, chnl_indx chan);
void        gtk_wave_display_play_set	(GtkWaveDisplay *wd, smpl_indx smpl, gboolean redraw);
void	    gtk_wave_display_win_set	(GtkWaveDisplay *wd, smpl_indx frst, gboolean redraw);
void	    gtk_wave_display_zoom_set	(GtkWaveDisplay *wd, guint zoom);
void	    gtk_wave_display_cursor_set	(GtkWaveDisplay *wd, GdkCursor *cursor);
void	    gtk_wave_display_scroll	(GtkWaveDisplay *wd, gint pixels);

#endif /* __GTK_WAVE_DISPLAY_H__ */
