#ifndef CONFIG_H
#define CONFIG_H

struct _config{
    void *value_ptr;  /* points to the storage space (eg. int, GdkColor etc ) */
    char *name;       /* name used in the gnomp3 structre and glade file      */
    int type;         /* See enum type below                                  */
    char *(*get_default)(char *); /* used to get the value of the default string.
				   * It will be passed the value of default_val 
				   * (below). Most config items will want to use the
				   * D() function, which simply returns the given 
				   * string. Other will use file_in_home() */
    char *default_val; /* the value the store is initialised to */
    GtkWidget *w;      /* points to the widget in the prefs dialog when it is open */
};

enum type{
    C_CHECK,  /* gtk check button. Storage type is int  */
    C_PATH,   /* gtk entry. Storage type is char array  */
    C_SPIN,   /* gtk spin button. Storage type is int   */
    C_COLOR,  /* gtk color picker. Storage type is GdkColor */
    C_BUTTON  /* gtk check button with no storage.      */
};

#define CONFIG_VAR(name, type, gd, def) {&gnomp3.name, #name, type, gd, def, NULL}

/*
 * This macro is used for defreferening the value_ptr in struct _config to the given
 * type.
 */
#define DEREF(type, c) *( (type *) c.value_ptr )

extern struct _config config_params[];

void config_load();
void config_save();
void config_handle_upgrade();
#endif
