#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# Control.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from GraphicObject import GraphicObject

class Control(GraphicObject):
  VISIBLE = True
  CANGETFOCUS=True
  FOCUS=False
  NAME=""
  Methods = {}

  def __init__(self, Parent, x, y, w=1, h=1, **properties):
    GraphicObject.__init__(self, Parent.SCREEN, **properties)
    self.SetColor('DIALOG','BACKGROUND')
    self.X = x
    self.Y = y
    self.H = h
    self.W = w

    self.PARENT = Parent
    self.Methods["CLICK"] = None
    self.Methods["PAINT"] = None
    self.Methods["GOTFOCUS"] = None
    self.Methods["LOSTFOCUS"] = None
    self.Methods["ACTION"] = None

    Parent.AddControl(self)


##  def DetermineAndSetColor(self, HasFocus):
##    if self.active:
##      if HasFocus :
##        self.SetColor(self.FOCUSCOLOR)
##      else:
##        self.SetColor(self.COLOR)
##    else:
##      pass
##      ##self.SetColor(4)

  def CreateProperty(self, Property, Value):
    self.__dict__[Property] = Value

  def SetMethod(self, MethodName, MethodValue):
    self.Methods[MethodName] = MethodValue

  def GetMethod(self, MethodName):
    if self.Methods.has_key(MethodName):
      return(self.Methods[MethodName])
    return None

  def Paint(self, v1,v2,v3):
    pass

  def ExecMethod(self, MethodName, Arg1, Arg2, Arg3):
    if not self.Methods.has_key(MethodName):
      return None
    if self.Methods[MethodName] == None:
      return None
    else:
      return self.Methods[MethodName](Arg1, Arg2, Arg3)

  def DeActivate(self, state):
    if self.active != state:
      self.active = state
      self.Paint(0,0,0)
      self.ExecMethod("REFRESH",None,None,None)


  def SetActiveState( self, state):
    self.DeActivate( state)


  def GetHeight(self):
    return self.H

  def GetWidth(self):
    return self.W


