#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# informix/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via Alexander Kuznetsov's
# Informix/Python Driver  *  Requires Kinfxdb 0.2+
# (http://thor.prohosting.com/~alexan/pub/Kinfxdb/Kinfxdb-0.2.tar.gz)
#
# NOTES:
#
#     dbame=      This is the Informix database to use (required)
#     host=      This is the Informix host for your connection  (optional)
#

#### THIS IS AN UNTESTED DRIVER ####
####      Any volunteers?       ####


from string import lower
import sys
from gnue.common.datasources import GDataObjects, GConditions
from gnue.common.apps import GDebug
from gnue.common.datasources.drivers import DBSIG2

raise "This data driver has not been upgraded to the new format."


import informixdb as SIG2api


class Informix_RecordSet(DBSIG2.RecordSet):
  pass


class Informix_ResultSet(DBSIG2.ResultSet):
  def __init__(self, dataObject, cursor=None, defaultValues={}, masterRecordSet=None):
    DBSIG2.ResultSet.__init__(self, dataObject, \
            cursor, defaultValues, masterRecordSet)
    self._recordSetClass = Informix_RecordSet
    self._uniqueIdField = "__GNUeF__uniqueKey_%s" % (self._dataObject.table)
    self._uniqueIdFormat = "ROWID='%s'"



class Informix_DataObject(DBSIG2.DataObject):
  def __init__(self):
    DBSIG2.DataObject.__init__(self)
    self._DatabaseError = SIG2api.DatabaseError
    self._resultSetClass = Informix_ResultSet


  def connect(self, connectData={}):
    GDebug.printMesg(9,"Informix database driver initializing")
    try:
      if connectData.has_key('host') and len(connectData['host']):
        db = connectData['dbname'] + "@" + connectData['host']
      else:
        db = connectData['dbname']
      self._dataConnection = SIG2api.connect( \
                   dbname=connectData['dbname'], \
                   user=connectData['_username'], \
                   passwd=connectData['_password'])
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

    self._postConnect()



  #
  # Schema (metadata) functions
  #

  # TODO: See postgresql for an example of what these functions do.

  # Return a list of the types of Schema objects this driver provides
  def getSchemaTypes(self):
    return [('view',_('Views'),1),
            ('table',_('Tables'),1)]

  # Return a list of Schema objects
  def getSchemaList(self, type=None):
    return []

  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):
    return None

  def _postConnect(self):
    self.triggerExtensions = TriggerExtensions(self._dataConnection)


class Informix_DataObject_Object(Informix_DataObject, \
      DBSIG2.DataObject_Object):

  def __init__(self):
    Informix_DataObject.__init__(self)

  def _buildQuery(self, conditions={},forDetail=None,additionalSQL=""):
    return DBSIG2.DataObject_Object._buildQuery(self, conditions,forDetail,additionalSQL)


class Informix_DataObject_SQL(Informix_DataObject, \
      DBSIG2.DataObject_SQL):
  def __init__(self):
    # Call DBSIG init first because Informix_DataObject needs to overwrite
    # some of its values
    DBSIG2.DataObject_SQL.__init__(self)
    Informix_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
    return DBSIG2.DataObject_SQL._buildQuery(self, conditions)


#
#  Extensions to Trigger Namespaces
#
class TriggerExtensions:

  def __init__(self, connection):
    self.__connection = connection




######################################
#
#  The following hashes describe
#  this driver's characteristings.
#
######################################

#
#  All datasouce "types" and corresponding DataObject class
#
supportedDataObjects = {
  'object': Informix_DataObject_Object,
  'sql':    Informix_DataObject_SQL
}

