#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# MenuBar.py
#
# DESCRIPTION:
#
# NOTES:

import sys, os, string
from wxPython.wx import *
from gnue.common.apps import GDebug
import MRUManager
from ModuleSupport import SupportedModules

#
#
#

class MenuBar(wxMenuBar):
  def __init__(self, instance):
    wxMenuBar.__init__(self)
    self.instance = instance
    self.instance.SetMenuBar(self)

    self._menus = {}
    self._menuItems = {'':[]}

    self._locationToWx= {}


  # Locations can be <loc>|<loc> where <loc> is <location>/<translation>@group
  def addMenu(self, location, translation=None, grouping=499):

    loc = ''
    if translation:
      location += '/' + translation
    if grouping:
      location += '@' + str(grouping)

    for part in location.split('|'):
      try:
        part, group = part.split('@')
        group = float(group)
      except:
        group = 500.0
      try:
        part, trans = part.split('/')
      except:
        trans = part
      nloc = loc + part + '|'
      if not self._menuItems.has_key(nloc):
        self._menuItems[nloc] = []
        self._menuItems[loc].append((int(grouping),grouping, trans, 1, nloc,
                                     0, 0, None, None, None, None))
      loc = nloc
    return loc


  def addAction(self, location, text, event,
                      grouping=499, canToggle=0, canDisable=0,
                      icon=None, hotkey=None, eventdata={}, help=""):

    location = self.addMenu(location)
    self._menuItems[location].append((int(grouping), grouping, text, 0, event,
                                 canToggle, canDisable, icon, hotkey,
                                 eventdata, help))


  #
  # Return the wxMenu(Item) associated with a location
  def getMenu(self, location):
    return self._locationToWx[location]



  #
  # Called by Instance.py when the menu can finally be built
  #
  def finalize(self):
    for group, order, text, isMenu, action, canToggle, canDisable, \
        icon, hotkey, eventdata, help in self._menuItems['']:
      self.__setupMenu(self, action, text)


  #
  # Recursively build (sub)menus
  #
  def __setupMenu(self, parent, location, text):
    items = self._menuItems[location]

    # Don't add empty menus (???)
    if not items:
      return

    menu = wxMenu()
    self._locationToWx[location] = menu
    parent.AppendMenu(wxNewId(), text, menu)
    items.sort()
    lastgroup = items[0][0]

    for group, order, text, isMenu, action, canToggle, canDisable, \
        icon, hotkey, eventdata, help in self._menuItems[location]:
      if group != lastgroup:
        menu.AppendSeparator()
        lastgroup = group

      if isMenu:
        self.__setupMenu(menu, action, text)
      else:
        mid = wxNewId()
        if hotkey:
          text += '\t' + hotkey
        item = wxMenuItem(menu, mid, text, help,
                  (canToggle and [wxITEM_CHECK] or [wxITEM_NORMAL])[0])
        if canToggle:
          EVT_MENU(self.instance._app, mid,
            lambda event, l=self.instance, m=item, e=action, x=eventdata:
                  l.dispatchEvent('%s:%s' % (m.IsChecked() and 'Show' or 'Hide',e), **x))
          self.instance.registerEventListeners( {
                   'Show:%s' % action:  lambda event, m=item: m.Check(1),
                   'Hide:%s' % action: lambda event, m=item: m.Check(0) })
        else:
          EVT_MENU(self.instance._app, mid,
            lambda event, l=self.instance, e=action, x=eventdata: l.dispatchEvent(e, **x))

        if canDisable:
          self.instance.registerEventListeners( {
                   'Enable:%s' % action:  lambda event, m=item: m.Enable(1),
                   'Disable:%s' % action: lambda event, m=item: m.Enable(0) })
        menu.AppendItem(item)


  #
  # Convenience methods to make the main menu bar appear to be a menu container
  #
  def AppendMenu(self, wxId, text, menu):
    self.Append(menu, text)


  def getEventHelp(self, handle):
    """
    Return the help string of a menu event,
    so that it could be used for toolbar icon tooltips too.
    (Two to two too...)
    """
    try:
      for menuItems in self._menuItems.values():
        for group, order, text, isMenu, action, canToggle, canDisable, \
          icon, hotkey, eventdata, help in menuItems:
          if action == handle:
            return (text, help)
    except:
      pass

    return None
