#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# forms/PropertyEditor.py
#
# DESCRIPTION:
# PropertyEditor wrapper for forms
#
# NOTES:
#


import sys, os, string
from wxPython.wx import *
from gnue.common.apps import GDebug
from gnue.common.formatting import GTypecast
from gnue.designer.base.tools.PropertyEditor import PropertyEditor as BasePropertyEditor
from gnue.designer.base.tools.PropertyEditor import InspectorPanel as BaseInspectorPanel
from gnue.designer.base.ToolBase import *

class PropertyEditor (BasePropertyEditor):
  def reset(self):
    BasePropertyEditor.reset(self)

    #
    # Is this a Positionable widget? If so, show x,y,w,h editor
    #
    try:
      layout = self.instance.incubator.elements[
             (self.object._type[2:]).lower()]['Positionable']
    except KeyError:
      if self.object._type == 'GFLabel':
        raise
      layout = False

    #
    # GFEntry?  Show the corresponding GFField
    #
    if self.object._type == 'GFEntry':
      GDebug.printMesg(4,'Adding a new entry property manager')
      self.addPage(FieldInspectorPanel(self, self.notebook), "Field")
      if self.object._block:
        self.addPage(EntryBlockInspectorPanel(self, self.notebook), "Block")

    # Child of Block?
    if self.object.findParentOfType('GFBlock',includeSelf=False):
      self.addPage(BlockInspectorPanel(self, self.notebook), "Block")

    # Block?
    if self.object._type == 'GFBlock' and hasattr(self.object,'datasource') \
        and self.object.datasource and hasattr(self.instance,'datasources'):
      self.addPage(DatasourceInspectorPanel(self, self.notebook), "Data Source")

    # Add layout
    if self.object._type == 'GFLayout':
      GDebug.printMesg(4,'Adding a new layout property manager')
      self.addPage(CharSizeInspectorPanel(self, self.notebook), 'Layout')

    # Add layout
    elif layout:
      GDebug.printMesg(4,'Adding a new layout property manager')
      self.addPage(CharPosInspectorPanel(self, self.notebook), 'Layout')


#
# Field properties (when Entry is selected)
#
class FieldInspectorPanel(BaseInspectorPanel):

  def setCurrent(self, object):
    self._setCurrent(object._field)

#
# Block properties (when Entry/Field is selected)
#
class BlockInspectorPanel(BaseInspectorPanel):

  def setCurrent(self, object):
    self._setCurrent(object.findParentOfType('GFBlock'))

class EntryBlockInspectorPanel(BaseInspectorPanel):
  def setCurrent(self, object):
    self._setCurrent(object._block)

#
# Datasource properties (when Block is selected)
#
class DatasourceInspectorPanel(BaseInspectorPanel):
  def setCurrent(self, object):
    try:
      if hasattr(object,'datasource') and object.datasource:
        self._setCurrent(self.editor.instance.datasources[object.datasource])
    except AttributeError:
      pass  # Happens on startup

#
# Character-cell layout (x,y) properties
#
class CharPosInspectorPanel(BaseInspectorPanel):

  NAMESPACE = "Char"

  def getAttributes(self, object):
    return {
       'Char:x':      { 'Typecast': GTypecast.whole },
       'Char:y':      { 'Typecast': GTypecast.whole },
       'Char:width':  { 'Typecast': GTypecast.whole },
       'Char:height': { 'Typecast': GTypecast.whole } }

  def getPageText(self):
    return "Display"

#
# Character-cell layout (x,y) properties
#
class CharSizeInspectorPanel(BaseInspectorPanel):

  NAMESPACE = "Char"

  def getAttributes(self, object):
    return {
       'Char:width':  { 'Typecast': GTypecast.whole },
       'Char:height': { 'Typecast': GTypecast.whole } }

  def getPageText(self):
    return "Display"
