#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# Project.py
#
# DESCRIPTION:
#
# NOTES:
#

from Parser import loadProject
import Objects

class Project:

  def __init__(self, location=None):
    if location:
      self.project = loadProject(self)
    else:
      self.project = Objects.GDProject()
    self.location = location

  def saveProject(self):
    if not self.location:
      raise "Location not set in Project.saveProject"

    # TODO: 1) check for file io errors
    # TODO: 2) make backup copy of a project file
    file = open(self.location,'w')
    file.write('<xml version="1.0">')
    file.write(self.project.dumpXML().encode('utf-8'))
    file.close()

  ##def getProperty(self, property): 
