#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# reports/LayoutEditor.py
#
# DESCRIPTION:
# The visual editor for Designer
#
# NOTES:
#

from wxPython.wx import *
from gnue.designer.base.ToolBase import ToolBase

class LayoutEditor (ToolBase):

  def init(self):
    self.panelColor = self.GetBackgroundColour()
    self._instance = self.instance
    self.rootObject = instance.rootObject
    self._app = instance._app
    self.rootObject.walk(self.inventoryObject)

    # EventAware provided by ToolBase
    self.registerEventListeners({
                       'ObjectSelected'      : self.onSetCurrentObject,
                       'ObjectCreated'       : self.onCreateObject,
                       'ObjectModified'      : self.onModifyObject,
                       'ObjectDeleted'       : self.onDeleteObject,
                      })


  def inventoryObject(self, object):
    pass

  def onSetCurrentObject (self, event):
    object = event.object
    handler = event.originator

  def onCreateObject (self, event):
    object = event.object
    handler = event.originator

  def onModifyObject (self, event):
    object = event.object
    handler = event.originator
    modifications = event.modifications

  def onDeleteObject (self, event):
    object = event.object
    handler = event.originator




