#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# uidrivers/html/widgets/_base.py
#
# DESCRIPTION:
#
# NOTES:
#

from gnue.common import events
from gnue.forms.GFForm import *
from gnue.forms.uidrivers._base.widgets._base import *
from gnue.forms.uidrivers.html.common import *


class HtmlWidget:

  _connectTable = {}

  def __init__(self, parent, uidriver, type, dhtml, id):
    self.dhtml = dhtml
    self.value = None
    self._type = type
    self._parent = parent
    self._children = []
    
    if parent:
      parent._children.append(self)
      
    self._uiDriver = uidriver
    self._id = id

  def Show(self):
    if self._type == "ENTRY":
      try:
        gfObject = self._uiDriver._IdToGFObj[self._id]
        if gfObject.style == 'checkbox':
          if self.value:
            self._uiDriver._htmlapp._dhtml[self._id] = (self.dhtml % "checked")
          else:
            self._uiDriver._htmlapp._dhtml[self._id] = (self.dhtml % "")
        else:
          self._uiDriver._htmlapp._dhtml[self._id] = (self.dhtml % self.value)
      except:
        print '*'+self.dhtml+'*'
        print '#'+self.value+'#'
    else:
      self._uiDriver._htmlapp._dhtml[self._id] = self.dhtml
    for child in self._children:
      child.Show()

  def GetId(self):
    return self._id

  def SetValue(self, value):
    self.value = value
    self.Show()

  def Connect(self, id, func):
    self._connectTable[id] = func


class UIHelper(UIWidget):
  def _addToCrossRef(self, widget, gfobject, uiobject):
    id = widget.GetId()
    self._uiDriver._IdToGFObj[id]=gfobject
    self._uiDriver._IdToUIObj[id]=uiobject

  def _deleteFromCrossRef(self, widget, object):
    id = widget.GetId()
    try:
      del self._uiDriver._IdToGFObj[id]
      del self._uiDriver._IdToUIObj[id]
    except:
      pass

  #
  # Override the base UIWidget functions
  #
  def show(self):
    for widget in self.widgets:
      widget.Show()

  def hide(self):
    for widget in self.widgets:
      widget.Hide()

          
  def showModal(self):
    for widget in self.widgets:
      widget.Show()

  def destroy(self):
    for widget in self.widgets:
      self.Destroy()


  def indexedFocus(self, index):
    pass

  def setValue(self, value, index=0, enabled=1):
    value = textEncode(value)
    widget = self.widgets[index]
    widget.SetValue(value)

  def setCursorPosition(self, position, index=0):
    pass

  def setSelectedArea(self, selection1, selection2, index=0):
    pass

  def createWidget(self, event, spacer):
    newWidget = self._createWidget(event, spacer)
    self._addToCrossRef(newWidget,event.object,self)
    return newWidget

  def cleanup(self, object):
    for widget in self.widgets[:]:
      id = widget.GetId()
      del self._uiDriver._IdToGFObj[id]
      del self._uiDriver._IdToUIObj[id]
      self.widgets.pop(0)
      self._deleteFromCrossRef(widget, object)
