# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# $Id: PrintForm.py 6851 2005-01-03 20:59:28Z jcater $
#
# DESCRIPTION:
# Handles the default "Print" option for the win32 client
#

__all__ = ['printForm']

import win32ui
import win32gui
import win32con
import win32print

from PIL import Image, ImageWin, ImageGrab

import time
from gnue.forms import VERSION

# Constants for GetDeviceCaps
HORZRES = 8
VERTRES = 10


def printForm(form, driver):
  print 'PrintForm start...'
  # Get a suitable title for the print job
  # We default to either "Form Name" or "Form Name" + "Page Name"
  # depending on if the page has a caption or not.
  subtitle = ""
  try:
    title = form.title
  except AttributeError:
    title = 'Untitled Form'
  try:
    if form._currentPage.caption:
      subtitle = ' (' + form._currentPage.caption + ')'
  except AttributeError:
    pass

  window = driver._gfObjToUIWidget[form].mainWindow
  l,t,r,b = win32gui.GetWindowRect(window.GetHwnd())
  image = ImageGrab.grab((l+2, t+2, r-2, b-2))
  image.save("tmp.bmp")

  # Open the bitmap
  bmp = Image.open ("tmp.bmp")
  print "original bitmap size =", bmp.size


  printer = win32print.GetDefaultPrinter()
  print printer
  phandle = win32print.OpenPrinter(printer)

  # Find the printer resolution to scale to
  hDC = win32ui.CreateDC ()
  hDC.CreatePrinterDC () # can optionally put a printer name in here
  printer_resolution = hDC.GetDeviceCaps (HORZRES), hDC.GetDeviceCaps (VERTRES)
  print "printer resolution =", printer_resolution

  # Resize the image to fit the page but not to overflow
  ratios = [printer_resolution[0] / bmp.size[0], printer_resolution[1] / bmp.size[1]]
  print "ratios =", ratios
  scale = min (ratios)
  print "scale =", scale

  # Create the printer document and send the page
  hDC.StartDoc ("GNUe PrintForm")
  hDC.StartPage ()

  dib = ImageWin.Dib (bmp)
  scaled_size = [scale * i for i in bmp.size]
  print "scaled bitmap size =", scaled_size
  dib.draw (hDC.GetHandleOutput (), [0, 0] + scaled_size)

  hDC.EndPage ()
  hDC.EndDoc ()

  win32print.ClosePrinter(phandle)
  del hDC
  del bmp
  os.remove("tmp.bmp")

  print 'PrintForm end.'
