#!/usr/bin/perl
#
# Syntax:   create-report.pl < infile.rtf > outfile.grd
#
# Then edit outfile.grd and change table name/connection name
# (and add connections/parameters if needed)
#

$FIELD_ENCLOSURE='::';

my %fields;
while (<>) {
  while (/${FIELD_ENCLOSURE}([A-Za-z0-9_]+)${FIELD_ENCLOSURE}/gm) {
    $fields{lc($1)} = 1;
  }
}


print "<?xml version=\"1.0\"?>\n";
print "<report>\n";
print "  <sources>\n"; 
print "    <datasource database=\"devel\" table=\"table\" name=\"dtsMain\"></datasource>\n";
print "  </sources>\n";
print "  <layout xmlns:out=\"GNUe:Reports:MailMerge\">\n";
print "    <section name=\"main\" source=\"dtsMain\">\n";
print "      <out:record>\n";

foreach $key (sort keys %fields) {
  print "        <out:field name=\"$key\"><field name=\"$key\"/></out:field>\n";
}

print "      </out:record>\n";
print "    </section>\n";
print "  </layout>\n";
print "</report>\n";


