#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# GRLayout.py
#
# DESCRIPTION:
# Classes related to the Layout section
#
# NOTES:
#


from gnue.common.definitions.GObjects import GObj
from gnue.common.apps import GDebug
from gnue.common.datasources import GConditions
from gnue.common.logic.GTrigger import GTrigger,GTriggerExtension

import string
from xml.sax import saxutils
from GRLayoutElement import GRLayoutElement


############################################################
#
# <formula> tag
#
class GRFormula (GRLayoutElement):
  def __init__(self, parent):
    GRLayoutElement.__init__(self, parent, 'GRFormula')
    self.section = None
    self.format = None
    self._inits = [self.init]
    self._value = ""

  def _buildObject(self):
    if self.section:
      self._section = string.lower(self.section)
    else:
      self._section = None

    return GRLayoutElement._buildObject(self)

  def init(self):
  
#    self._validTriggers = {'__FORMULA__': '__FORMULA__'}
#    self._mymapper.addField(self.name)

    code = ""
    for f in self.getChildrenAsContent().code.split('\n'):
      if f.strip()[:1] != '#':
        code += f + ' '
    self._code = code

  def process(self, dest, mapper, isfirst, islast, firstSection, nextSection):
    ## structuralComment(dest,"<!-- [formula:%s] -->" % (self.section))
    ##self._mymapper.setField(self._field, self.function
#    dest.write (self._mymapper.getSummary(self._field, self.function, self.format))
    ## structuralComment(dest,"<!-- [/formula] -->")
    return nextSection
    



      
