/*
**  MailWindowController.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_MailWindowController
#define _GNUMail_H_MailWindowController

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

@class ExtendedOutlineView;
@class Folder;
@class LabelWidget;
@class LocalStore;
@class MailHeaderCell;
@class MailWindow;
@class Message;
@class POP3Folder;
@class URLName;

@interface MailWindowController : NSWindowController
{
  //
  // Outlets
  //
  IBOutlet NSScrollView *tableScrollView; 
  IBOutlet NSScrollView *textScrollView;

  IBOutlet NSSplitView *splitView;
  IBOutlet NSTextView *textView;

  IBOutlet NSButton *mailboxes;
  IBOutlet NSButton *compose;
  IBOutlet NSButton *forward;
  IBOutlet NSButton *reply;
  IBOutlet NSButton *addresses;
  IBOutlet NSButton *find;

  IBOutlet NSTextField *label;
  
  IBOutlet NSTableColumn *statusColumn;
  IBOutlet NSTableColumn *idColumn;
  IBOutlet NSTableColumn *dateColumn;
  IBOutlet NSTableColumn *fromColumn;
  IBOutlet NSTableColumn *subjectColumn;
  IBOutlet NSTableColumn *sizeColumn;

  IBOutlet NSButton *icon;
  
#ifdef MACOSX
  IBOutlet NSProgressIndicator *progressIndicator;
  IBOutlet NSView *navigationView;
  IBOutlet NSDrawer *drawer;
  IBOutlet ExtendedOutlineView *outlineView;
#endif

  //
  // Other ivars
  //
  NSMutableArray *allMessageViewWindowControllers;
  NSArray *allMessages;
  NSArray *allContainers;
  
  NSFont *deletedMessageFont;
  NSFont *recentMessageFont;
  NSFont *seenMessageFont;

  Folder *folder;

  MailHeaderCell *mailHeaderCell;

  NSString *previousOrder;
  NSString *currentOrder;
  
  NSTimer *animation;
  int animation_index;
   
  id dataView;
  int dataViewType;

  BOOL draftsOrSentFolder;
  BOOL shouldCloseStore;
  BOOL isReverseOrder;
  BOOL showAllHeaders;
  BOOL showRawSource;
  BOOL isReloading;
  
  //
  // Public ivars
  //
  @public
    IBOutlet NSButton *next;
    IBOutlet NSButton *previous;
    IBOutlet id get;
    IBOutlet id delete;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;
- (void) dealloc;

//
// Action methods
//
- (IBAction) doubleClickedOnDataView: (id) sender;

- (IBAction) deleteMessage: (id) sender;

- (IBAction) lastMessage: (id) sender;
- (IBAction) firstMessage: (id) sender;

- (IBAction) pageDownMessage: (id) sender;
- (IBAction) pageUpMessage: (id) sender;

- (IBAction) nextMessage: (id) sender;
- (IBAction) nextUnreadMessage: (id) sender;
- (IBAction) previousMessage: (id) sender;
- (IBAction) previousUnreadMessage: (id) sender;

- (IBAction) collapseItem: (id) sender;
- (IBAction) expandItem: (id) sender;

- (IBAction) forwardMessage: (id) sender;
- (IBAction) replyMessage: (id) sender;

- (IBAction) viewMessageInWindow: (id) sender;

- (IBAction) filtersHaveChanged: (id) sender;
- (IBAction) updateMessageFlags: (id) sender;

- (IBAction) getNewMessages: (id) sender;

#ifdef MACOSX
- (IBAction) openOrCloseDrawer: (id) sender;
#endif

//
// Access / mutation methods
//
- (Folder *) folder;
- (void) setFolder: (Folder *) theFolder;

- (Message *) selectedMessage;
- (NSArray *) selectedMessages;

- (BOOL) showAllHeaders;
- (void) setShowAllHeaders: (BOOL) aBOOL;

- (BOOL) showRawSource;
- (void) setShowRawSource: (BOOL) aBool;

- (id) dataView;
- (int) dataViewType;
- (void) setDataViewType: (int) theType;

- (NSTextView *) textView;

- (NSString *) currentOrder;
- (void) setCurrentOrder: (NSString *) theCurrentOrder;

- (NSString *) previousOrder;
- (void) setPreviousOrder: (NSString *) thePreviousOrder;

- (MailHeaderCell *) mailHeaderCell;

- (NSMutableArray *) allMessageViewWindowControllers;

- (Message *) messageAtRow: (int) theRow;

- (NSArray *) allMessages;
- (NSArray *) allContainers;

//
// delegate methods
//
- (int) numberOfRowsInTableView: (NSTableView *)aTableView;

- (id)           tableView: (NSTableView *) aTableView
 objectValueForTableColumn: (NSTableColumn *) aTableColumn
                       row: (int) rowIndex;

- (void) tableView: (NSTableView *) aTableView
   willDisplayCell: (id) aCell
    forTableColumn: (NSTableColumn *) aTableColumn
               row: (int) rowIndex;

- (void) tableViewSelectionDidChange: (NSNotification *) aNotification;

-  (void) textView: (NSTextView *) aTextView
     clickedOnCell: (id <NSTextAttachmentCell>) attachmentCell
	    inRect: (NSRect) cellFrame
           atIndex: (unsigned) charIndex;

- (BOOL) textView: (NSTextView *) textView
    clickedOnLink: (id) link 
          atIndex: (unsigned) charIndex;

- (BOOL) windowShouldClose: (id) sender;

- (void) windowWillClose: (NSNotification *) not;

- (void) windowDidLoad;

- (void) windowDidBecomeKey: (NSNotification *) aNotification;


//
// Other methods
//
- (void) startAnimation;
- (void) stopAnimation;

- (void) setSelectedMessagesAsTransferred;

- (void) dataViewShouldReloadData;

- (void) updateStatusLabel;
- (void) updateStatusLabelWithMessage: (NSString *) theString;
- (void) reloadMessageList: (NSNotification *) aNotification;

@end


//
// Private interface for MailWindowContrller
//
@interface MailWindowController (Private)

- (void) _closeAllMessageViewWindows;

- (void) _fontValuesHaveChanged;

- (void) _initializeFonts;

- (void) _loadAccessoryViews;

- (id) _objectValueForTableColumn: (NSTableColumn *) aTableColumn
                          message: (Message *) theMessage
                             item: (id) theItem;

- (void) _outlineViewShouldReloadData;

- (void) _reloadTableColumns: (id) sender;

- (void) _restoreImage;

- (void) _restoreSortingOrder;

- (void) _restoreSplitViewSize;

- (void) _selectionDidChange;

- (void) _setIndicatorImageForTableColumn: (NSTableColumn *) aTableColumn;

- (void) _showMessage: (id) sender;

- (void) _tableViewShouldReloadData;

- (void) _updateAnimatedIcon: (id) sender;

- (void) _willDisplayCellForMessage: (Message *) theMessage
			       cell: (id) theCell
                        tableColumn: (NSTableColumn *) theTableColumn
                                row: (int) rowIndex
                               item: (id) theItem;

- (void) _zeroIndexOffset;

@end

#endif // _GNUMail_H_MailWindowController
