/*
**  Task.m
**
**  Copyright (c) 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "Task.h"

#include "Constants.h"

#include <Pantomime/Message.h>

#include <Foundation/NSArray.h>
#include <Foundation/NSDebug.h>
#include <Foundation/NSString.h>
#include <Foundation/NSValue.h>

//
//
//
@implementation Task

- (id) init
{
  self = [super init];

  [self setMessage: nil];
  [self setKey: nil];
  [self setSendingKey: nil];
  [self setOp: 0];
  [self setSubOp: 0];
  [self setImmediate: NO];
  [self setOrigin: ORIGIN_USER];
  [self setDate: [NSDate date]];
  [self setRunning: NO];
  [self setOwner: nil];
  [self setFilteredMessagesFolders: [NSMutableArray array]];
  [self setFilteredMessagesCount: 0];
  [self setReceivedMessagesCount: 0];

  return self;
}

//
//
//
- (void) dealloc
{
  NSDebugLog(@"Task: -dealloc");

  RELEASE(message);
  RELEASE(key);
  RELEASE(sendingKey);
  RELEASE(date);
  RELEASE(owner);
  RELEASE(filteredMessagesFolders);

  [super dealloc];
}


//
// NSCoding protocol
//
// We do NOT store the owner and if the task is running. The task
// is obviously not running when it's encoded :-)
//
- (void) encodeWithCoder: (NSCoder *) theCoder
{
  [theCoder encodeObject: [self message]];
  [theCoder encodeObject: [self key]];
  [theCoder encodeObject: [self sendingKey]];
  [theCoder encodeObject: [NSNumber numberWithInt: [self op]]];
  [theCoder encodeObject: [NSNumber numberWithInt: [self subOp]]];
  [theCoder encodeObject: [self date]];
}


//
//
//
- (id) initWithCoder: (NSCoder *) theCoder
{
  self = [super init];

  [self setMessage: [theCoder decodeObject]];
  [self setKey: [theCoder decodeObject]];
  [self setSendingKey: [theCoder decodeObject]];
  [self setOp: [[theCoder decodeObject] intValue]];
  [self setSubOp: [[theCoder decodeObject] intValue]];
  [self setDate: [theCoder decodeObject]];
  [self setRunning: NO];
  [self setOwner: nil];
  [self setFilteredMessagesFolders: [NSMutableArray array]];
  [self setFilteredMessagesCount: 0];
  [self setReceivedMessagesCount: 0];

  return self;
}


//
// NSCopying protocol
//
- (id) copyWithZone: (NSZone *) zone
{
  Task *aTask;

  aTask = [[Task alloc] init];
  [aTask setMessage: [self message]];
  [aTask setKey: [self key]];
  [aTask setSendingKey: [self sendingKey]];
  [aTask setOp: [self op]];
  [aTask setSubOp: [self subOp]];
  [aTask setDate: [self date]];
  [aTask setRunning: [self running]];
  [aTask setOwner: [self owner]];
  [aTask setFilteredMessagesFolders: [self filteredMessagesFolders]];
  [aTask setReceivedMessagesCount: [self receivedMessagesCount]];

  return aTask;
}


//
//
//
- (id) message
{
  return message;
}


//
//
//
- (void) setMessage: (id) theMessage
{
  if ( theMessage )
    {
      RETAIN(theMessage);
      RELEASE(message);
      message = theMessage;
    }
  else 
    {
      DESTROY(message);
    }
}


//
//
//
- (id) key
{
  return key;
}

- (void) setKey: (id) theKey
{
  if ( theKey )
    {
      RETAIN(theKey);
      RELEASE(key);
      key = theKey;
    }
  else
    {
      DESTROY(key); 
    }
}


//
//
//
- (id) sendingKey
{
  return sendingKey;
}

- (void) setSendingKey: (id) theKey
{
  if ( theKey )
    {
      RETAIN(theKey);
      RELEASE(sendingKey);
      sendingKey = theKey;
    }
  else
    {
      DESTROY(sendingKey);
    }
}


//
//
//
- (int) op
{
  return op;
}

- (void) setOp: (int) theOp
{
  op = theOp;
}


//
//
//
- (int) subOp
{
  return subOp;
}

- (void) setSubOp: (int) theSubOp
{
  subOp = theSubOp;
}


//
//
//
- (BOOL) immediate
{
  return immediate;
}

- (void) setImmediate: (BOOL) theBOOL
{
  immediate = theBOOL;
}


//
//
//
- (NSDate *) date
{
  return date;
}

- (void) setDate: (NSDate *) theDate
{
  RETAIN(theDate);
  RELEASE(date);
  date = theDate;
}


//
//
//
- (int) origin
{
  return origin;
}

- (void) setOrigin: (int) theOrigin
{
  origin = theOrigin;
}


//
//
//
- (BOOL) running
{
  return running;
}

- (void) setRunning: (BOOL) theBOOL
{
  running = theBOOL;
}


//
//
//
- (id) owner
{
  return owner;
}

- (void) setOwner: (id) theOwner
{
  if ( theOwner )
    {
      RETAIN(theOwner);
      RELEASE(owner);
      owner = theOwner;
    }
  else
    {
      DESTROY(owner);
    }
}


//
//
//
- (NSMutableArray *) filteredMessagesFolders
{
  return filteredMessagesFolders;
}

- (void) setFilteredMessagesFolders: (NSMutableArray *) theMutableArray
{
  if ( theMutableArray )
    {
      RETAIN(theMutableArray);
      RELEASE(filteredMessagesFolders);
      filteredMessagesFolders = theMutableArray;
    }
  else
    {
      DESTROY(filteredMessagesFolders);
    }
}


//
//
//
- (int) filteredMessagesCount
{
  return filteredMessagesCount;
}

- (void) setFilteredMessagesCount: (int) theCount
{
  filteredMessagesCount = theCount;
}


//
//
//
- (int) receivedMessagesCount
{
  return receivedMessagesCount;
}

- (void) setReceivedMessagesCount: (int) theCount
{
  receivedMessagesCount = theCount;
}

@end
