/*
 * Copyright (C) 2002,2003 Pascal Haakmat.
 * Licensed under the GNU GPL.
 * Absolutely no warranty.
 */

#define GTK_DISABLE_DEPRECATED 1
#define GNOME_DISABLE_DEPRECATED 1

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#include <gnome.h>
#include <libgnomeui/gnome-window-icon.h>
#include <glade/glade.h>
#include "pref.h"
#include "mem.h"
#include "action.h"
#include "gui.h"
#include "file.h"
#include "module.h"
#include "shell.h"

extern int Emergency;
extern snd *clipboard;
extern shell *clipboard_shell;
extern int quit_requested;

struct gui_pref_controls gui_pref_controls;
GdkPixmap *mixer_level = NULL,
    *mixer_mute_on = NULL, 
    *mixer_mute_off = NULL, 
    *mixer_solo_on = NULL,
    *mixer_solo_off = NULL;
GList *shells = NULL;
GdkColormap *colormap;
GdkFont *grid_font;
GdkFont *info_font;
GdkColor colors[NUM_COLORS];
#define NUM_CURSORS 4
GdkCursor *cursor_cache[NUM_CURSORS] = {
    NULL, NULL, NULL, NULL
};
GdkCursorType cursor_type_cache[NUM_CURSORS] = {
    0, 0, 0, 0
};
char *color_names[] = {
    "colors:background",
    "colors:point_record",
    "colors:point_play",
    "colors:wave",
    "colors:wave_lighttone",
    "colors:wave_darktone",
    "colors:zero",
    "colors:selection_wave",
    "colors:selection",
    "colors:selection_background",
    "colors:block",
    "colors:mark",
    "colors:grid",
    "colors:grid_font",
    "colors:info_font",
    "colors:info_font_record",
    "colors:info_font_play", 
    "dummy",
    "colors:marker_slope_main",
    "colors:marker_slope_aux",
    "colors:marker_text_background",
    "colors:marker_text",
    "colors:toggles_mute",
    "colors:toggles_solo",
    NULL,
};

void
gui_window_set_cursor(GdkWindow *w,
                      GdkCursorType type) {
    int i;
    GdkCursor *cursor;
    for(i = 0; i < NUM_CURSORS; i++) {
        if(cursor_cache[i] && cursor_type_cache[i] == type) {
            gdk_window_set_cursor(w, cursor_cache[i]);
            return;
        }
    }
    cursor = gdk_cursor_new(type);
    gdk_window_set_cursor(w, cursor);
    for(i = 0; i < NUM_CURSORS; i++) {
        if(!cursor_cache[i]) {
            cursor_type_cache[i] = type;
            cursor_cache[i] = cursor;
            return;
        }
    }
}

GtkWidget *
gui_file_selection_new(const char *title) {
    GtkWidget *fs = gtk_file_selection_new(title);
    return fs;
}

GdkWindow *
gui_get_window(GtkWidget *w) {
    GdkWindow *window;
    if(GTK_WIDGET_TOPLEVEL(w)) {
        window = w->window;
    } else {
        if (GTK_WIDGET_NO_WINDOW (w))
            window = w->window;
        else
            window = gdk_window_get_parent(w->window);
    }
    return window;
}

void
gui_get_widget_position_absolute(GtkWidget *w,
                                 int *x,
                                 int *y) {
    GdkWindow *window = gui_get_window(w);
    //gdk_window_get_position(window, x, y);
    gdk_window_get_origin(window, x, y);
}



/*
 * Yields control to the GTK event handler to process outstanding GUI
 * events such as redraws and button clicks. This function returns 1
 * if this processing resulted in the user selecting "quit".
 *
 * @return 0 for success, 1 if the gui has been teared down.
 */

int
gui_yield() {
    if(Emergency)
        return 1;

    while(gtk_events_pending())
        gtk_main_iteration_do(FALSE);
    return quit_requested;
}

int 
gui_yes_no(const char *title,
           const char *format,
           ...) {
    va_list ap;
    char *message;
    int button;
    GtkWidget *dialog;

    message = (char *) mem_alloc(strlen(format) + 4096);

    if(!message) {
        FAIL("could not get memory to display error string. start of error: %s\n", format);
        return GUI_CANCEL;
    }
    
    va_start(ap, format);
    vsnprintf(message, strlen(format) + 4096, format, ap);
    va_end(ap);

#ifdef HAVE_GNOME2
    dialog = gtk_message_dialog_new(NULL,
                                    GTK_DIALOG_MODAL,
                                    GTK_MESSAGE_QUESTION,
                                    GTK_BUTTONS_YES_NO,
                                    message);
    button = gtk_dialog_run(GTK_DIALOG(dialog));
    switch(button) {
    case GTK_RESPONSE_YES:
        button = GUI_YES;
        break;
    case GTK_RESPONSE_NO:
        button = GUI_NO;
        break;
    default:
        button = GUI_CANCEL;
    }
    gtk_widget_destroy(dialog);
#else    
    dialog = gnome_message_box_new(message,
                                   GNOME_MESSAGE_BOX_QUESTION,
                                   GNOME_STOCK_BUTTON_YES,
                                   GNOME_STOCK_BUTTON_NO,
                                   NULL);
    button = gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
#endif

    free(message);
    DEBUG("returning button: %d\n", button);
    return button;
}

void
gui_alert(const char *format,
          ...) {
    va_list ap;
    char message[4096];
    GtkWidget *dialog;

    va_start(ap, format);
    vsnprintf(message, 4096, format, ap);
    va_end(ap);

    if(Emergency) {
        DEBUG("MESSAGE: %s", message);
        return;
    }

#ifdef HAVE_GNOME2
    dialog = gtk_message_dialog_new(NULL,
                                    GTK_DIALOG_MODAL,
                                    GTK_MESSAGE_INFO,
                                    GTK_BUTTONS_CLOSE,
                                    message);
    gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
#else    
    dialog = gnome_message_box_new(message,
                                   GNOME_MESSAGE_BOX_WARNING,
                                   GNOME_STOCK_BUTTON_OK,
                                   NULL);
    gnome_dialog_run(GNOME_DIALOG(dialog));
#endif

}

/*
 * Preferences dialog.
 */

void
gui_preferences_cancel_clicked(GtkButton *w,
                               gpointer user_data) {
    gtk_widget_hide(gui_pref_controls.dialog);
}

void
gui_preferences_ok_clicked(GtkButton *w,
                           gpointer user_data) {
    gtk_widget_hide(gui_pref_controls.dialog);
    DEBUG("ok\n");
    pref_set_float("default_sample_rate", gtk_spin_button_get_value(GTK_SPIN_BUTTON(gui_pref_controls.default_sample_rate)));
    pref_set_int("playback_channels", gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gui_pref_controls.playback_channels)));
    pref_set_int("max_tracks", gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gui_pref_controls.max_tracks)));
    pref_set_string("playback_device", gtk_entry_get_text(GTK_ENTRY(gui_pref_controls.playback_device)));
    pref_set_string("record_device", gtk_entry_get_text(GTK_ENTRY(gui_pref_controls.record_device)));

    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gui_pref_controls.default_sample_width_8)))
        pref_set_int("default_sample_width", 1);
    else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gui_pref_controls.default_sample_width_16)))
        pref_set_int("default_sample_width", 2);
    else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gui_pref_controls.default_sample_width_32)))
        pref_set_int("default_sample_width", 4);
    pref_sync();
    
}

void
gui_preferences_populate() {
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(gui_pref_controls.default_sample_rate),
                              pref_get_as_float("default_sample_rate"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(gui_pref_controls.playback_channels),
                              pref_get_as_int("playback_channels"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(gui_pref_controls.max_tracks),
                              pref_get_as_int("max_tracks"));
    gtk_entry_set_text(GTK_ENTRY(gui_pref_controls.playback_device),
                       pref_get_as_string("playback_device"));
    gtk_entry_set_text(GTK_ENTRY(gui_pref_controls.record_device),
                       pref_get_as_string("record_device"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gui_pref_controls.default_sample_width_16), TRUE);
    if(pref_get_as_int("default_sample_width") == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gui_pref_controls.default_sample_width_8), TRUE);
    else if(pref_get_as_int("default_sample_width") == 2)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gui_pref_controls.default_sample_width_16), TRUE);
    else if(pref_get_as_int("default_sample_width") == 4)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gui_pref_controls.default_sample_width_32), TRUE);
}

void
gui_preferences_activate(GtkMenuItem *menuitem,
                         gpointer user_data) {
    if(!(GTK_OBJECT_FLAGS(GTK_OBJECT(gui_pref_controls.dialog)) & GTK_VISIBLE)) {
        gui_preferences_populate();
        gtk_widget_show(GTK_WIDGET(gui_pref_controls.dialog));
    } else {
        gdk_window_raise(GTK_WIDGET(gui_pref_controls.dialog)->window);
    }
}

void
gui_new_activate(GtkWidget *w,
                 gpointer user_data) {    
    action_result *ar = action_do(ACTION_FILE_NEW_NEW());
    shell *shl = action_result_as_ptr(ar);
    action_do(ACTION_FILE_INIT_NEW(shl));
}

void 
gui_open_activate(GtkWidget *w,
                  gpointer user_data) {
    action *a = ACTION_FILE_SELECT_NEW();
    action_do(a);
}


char *
disabled_bindings_for_clipboard[] = {
    "copy",
    "cut",
    "paste",
    "paste_over",
    "paste_fit",
    "paste_mix",
    NULL
};

void 
gui_show_clipboard_activate(GtkMenuItem *menuitem,
                            gpointer user_data) {

    DEBUG("show_clipboard\n");
    if(clipboard_shell) {
        gdk_window_raise(gtk_widget_get_parent_window(GTK_WIDGET(clipboard_shell)));
    } else {
        clipboard_shell = shell_new();
        clipboard_shell->sr = clipboard;
        mixer_configure(clipboard_shell->mixer, 
                        MIN(pref_get_as_int("playback_channels"), clipboard_shell->sr->channels), 
                        clipboard_shell->sr->channels);
        shell_bindings_disable(clipboard_shell, disabled_bindings_for_clipboard);
        gtk_widget_show(GTK_WIDGET(clipboard_shell->appwindow));
        shell_status_default_set(clipboard_shell);
    }
}

void
gui_exit_activate(GtkWidget *w,
                  shell *shl) {
    action_do(ACTION_EXIT_NEW());
}


int 
gui_init(int argc, char *argv[]) {
    int err, i, color;
    struct stat statbuf;
    GladeXML *xml;
    GdkColor black;
    g_thread_init(NULL);
#ifdef HAVE_GNOME2
    gdk_threads_init();
    gnome_program_init(PACKAGE, VERSION, LIBGNOMEUI_MODULE, argc, argv, 
                       GNOME_PARAM_POPT_TABLE, NULL, 
                       GNOME_PROGRAM_STANDARD_PROPERTIES, NULL);
            
#else
    gnome_init(PACKAGE, VERSION, argc, argv);
#endif
    glade_gnome_init();
    gnome_window_icon_set_default_from_file(ICON_FILE);
    colormap = gdk_colormap_get_system();

    /* Allocate colors. */

    for(i = 0; color_names[i]; i++) {
        if(strcmp(color_names[i], "dummy") == 0)
            continue;
        color = (int)strtol(pref_get_as_string(color_names[i]), NULL, 16);
        colors[i].pixel = 0;
        colors[i].red = (color & 0xFF0000) >> 8;
        colors[i].green = (color & 0x00FF00);
        colors[i].blue = (color & 0x0000FF) << 8;
        colors[i].red |= (colors[i].red >> 8);
        colors[i].green |= (colors[i].green >> 8);
        colors[i].blue |=  colors[i].blue >> 8;
        gdk_colormap_alloc_color(colormap, &colors[i], FALSE, TRUE);
    }

    grid_font = gdk_font_load("fixed");
    info_font = gdk_font_load("fixed");

    err = stat(PRIMARY_GLADE_FILE, &statbuf);
    if(!err) 
        xml = glade_xml_new(PRIMARY_GLADE_FILE, NULL, NULL);
    else
        xml = glade_xml_new(SECONDARY_GLADE_FILE, NULL, NULL);

    if(!xml) {
        FAIL("could not find interface definition, " "looked at %s:%s.", 
             PRIMARY_GLADE_FILE, SECONDARY_GLADE_FILE);
        return -1;
    }

    gui_pref_controls.dialog = glade_xml_get_widget(xml, "preferencesdialog");
    gui_pref_controls.default_sample_rate = glade_xml_get_widget(xml, "preferences_default_sample_rate");
    gui_pref_controls.default_sample_width_8 = glade_xml_get_widget(xml, "preferences_default_sample_width_8");
    gui_pref_controls.default_sample_width_16 = glade_xml_get_widget(xml, "preferences_default_sample_width_16");
    gui_pref_controls.default_sample_width_32 = glade_xml_get_widget(xml, "preferences_default_sample_width_32");
    gui_pref_controls.playback_device = glade_xml_get_widget(xml, "preferences_playback_device");
    gui_pref_controls.record_device = glade_xml_get_widget(xml, "preferences_record_device");
    gui_pref_controls.playback_channels = glade_xml_get_widget(xml, "preferences_playback_channels");
    gui_pref_controls.max_tracks = glade_xml_get_widget(xml, "preferences_max_tracks");

    g_signal_connect(GTK_OBJECT(glade_xml_get_widget(xml, "preferences_ok")), "clicked",
                     G_CALLBACK(gui_preferences_ok_clicked), NULL);
    g_signal_connect(GTK_OBJECT(glade_xml_get_widget(xml, "preferences_cancel")), "clicked",
                     G_CALLBACK(gui_preferences_cancel_clicked), NULL);
    
    g_object_unref(G_OBJECT(xml));
    
    /* Load images. */

    gdk_color_black(colormap, &black);

    mixer_mute_on =
        gdk_pixmap_colormap_create_from_xpm(NULL, colormap, NULL, &black,
                                            MIXER_MUTE_ON_FILE);
    mixer_mute_off = 
        gdk_pixmap_colormap_create_from_xpm(NULL, colormap, NULL, &black,
                                            MIXER_MUTE_OFF_FILE);
    mixer_solo_on = 
        gdk_pixmap_colormap_create_from_xpm(NULL, colormap, NULL, &black,
                                            MIXER_SOLO_ON_FILE);    
    mixer_solo_off = 
        gdk_pixmap_colormap_create_from_xpm(NULL, colormap, NULL, &black,
                                            MIXER_SOLO_OFF_FILE);
    mixer_level = 
        gdk_pixmap_colormap_create_from_xpm(NULL, colormap, NULL, &black,
                                            MIXER_LEVEL_FILE);
    
    return 0;
}

void
gui_file_loader(const char *filename) {
    action_result *ar = action_do(ACTION_FILE_NEW_NEW());
    shell *shl = action_result_as_ptr(ar);
    action_do(ACTION_FILE_OPEN_NEW(shl, filename));
}

int 
gui_run(int argc,
        char *argv[]) {
    int i;
    action_result *ar;
    shell *shl;
    clipboard = (snd *)snd_new();
    snd_name_set(clipboard, "clipboard");

    if(argc >= 2) {
        for(i = 1; i < argc; i++)
            gtk_init_add((GtkFunction)gui_file_loader, argv[i]);
    } else {
        ar = action_do(ACTION_FILE_NEW_NEW());
        shl = action_result_as_ptr(ar);
        action_do(ACTION_FILE_INIT_NEW(shl));
    }

    gtk_main();
    return 0;
}


/**
 * option_menu_index:
 * @optionmenu: a gtkoptionmenu
 * 
 * Tries to find out (in an ugly way) the selected
 * item in @optionmenu
 * 
 * Return value: the selected index
 * @author: Almer. S. Tigelaar.
 **/
int
gui_option_menu_get_active (GtkOptionMenu *optionmenu) {
    GtkMenu *menu;
    GtkMenuItem *selected;
    GList *iterator;
    int index = -1;
    int i = 0;

    g_return_val_if_fail (optionmenu != NULL, -1);
    
    menu = (GtkMenu *) gtk_option_menu_get_menu (optionmenu);
    iterator = GTK_MENU_SHELL (menu)->children;
    selected = (GtkMenuItem *) gtk_menu_get_active (menu);
    
    while (iterator) {
        
        if (iterator->data == selected) {
            
            index = i;
            break;
        }
        
        iterator = iterator->next;
        i++;
    }

    return index;
}


