indexing

	description:

		"Eiffel assertions followed by a semicolon"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2002, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 13:02:30 $"
	revision: "$Revision: 1.6 $"

class ET_ASSERTION_SEMICOLON

inherit

	ET_ASSERTION_ITEM

creation

	make

feature {NONE} -- Initialization

	make (an_assertion: like assertion; a_semicolon: like semicolon) is
			-- Create a new assertion-semicolon.
		require
			an_assertion_not_void: an_assertion /= Void
			a_semicolon_not_void: a_semicolon /= Void
		do
			assertion := an_assertion
			semicolon := a_semicolon
		ensure
			assertion_set: assertion = an_assertion
			semicolon_set: semicolon = a_semicolon
		end

feature -- Access

	assertion: ET_ASSERTION
			-- Assertion in list of assertions

	semicolon: ET_SYMBOL
			-- Semicolon separator

	position: ET_POSITION is
			-- Position of first character of
			-- current node in source code
		do
			Result := assertion.position
		end

	break: ET_BREAK is
			-- Break which appears just after current node
		do
			Result := semicolon.break
		end

feature -- Processing

	process (a_processor: ET_AST_PROCESSOR) is
			-- Process current node.
		do
			a_processor.process_assertion_semicolon (Current)
		end

invariant

	semicolon_not_void: semicolon /= Void

end
