indexing

	description:

		"Eiffel loop variants"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2002, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 13:02:30 $"
	revision: "$Revision: 1.7 $"

class ET_VARIANT

inherit

	ET_AST_NODE

creation

	make

feature {NONE} -- Initialization

	make (a_tag: like tag; an_expression: like expression) is
			-- Create a new empty loop variant clause.
		do
			variant_keyword := tokens.variant_keyword
			tag := a_tag
			expression := an_expression
		ensure
			tag_set: tag = a_tag
			expression_set: expression = an_expression
		end

feature -- Access

	variant_keyword: ET_KEYWORD
			-- 'variant' keyword

	tag: ET_TAG
			-- Tag

	expression: ET_EXPRESSION
			-- Integer expression

	position: ET_POSITION is
			-- Position of first character of
			-- current node in source code
		do
			Result := variant_keyword.position
			if Result.is_null then
				if tag /= Void then
					Result := tag.position
				elseif expression /= Void then
					Result := expression.position
				end
			end
		end

	break: ET_BREAK is
			-- Break which appears just after current node
		do
			if expression /= Void then
				Result := expression.break
			elseif tag /= Void then
				Result := tag.break
			else
				Result := variant_keyword.break
			end
		end

feature -- Setting

	set_variant_keyword (a_variant: like variant_keyword) is
			-- Set `variant_keyword' to `a_variant'.
		require
			a_variant_not_void: a_variant /= Void
		do
			variant_keyword := a_variant
		ensure
			variant_keyword_set: variant_keyword = a_variant
		end

feature -- Processing

	process (a_processor: ET_AST_PROCESSOR) is
			-- Process current node.
		do
			a_processor.process_variant (Current)
		end

invariant

	variant_keyword_not_void: variant_keyword /= Void

end
