/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_GQL_PG_UTIL_H)
#define __INC_GQL_PG_UTIL_H

#include <libpq-fe.h>

namespace GQL
{

namespace PG
{

inline const char *getvalue(PGresult *result, int row, int col)
{
  return PQgetisnull(result, row, col) ? 0 : PQgetvalue(result, row, col);
}

inline std::string *get_new_string(PGresult *result, int row, int col)
{
  return PQgetisnull(result, row, col) ? 0 : 
    new std::string(PQgetvalue(result, row, col), 
                    PQgetlength(result, row, col));
}

}

}

#endif
