/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_WARNABLE_H)
#define __INC_WARNABLE_H

#include <queue>

#include <sigc++/sigc++.h>

#include <gql++/warning.h>

namespace GQL
{

class Warnable : public SigC::Object
{
  public:
    Warnable();
    const SQLWarning *get_warning() {
      return(warnings_.front());
    }
    void next_warning() {
      delete warnings_.front();
      warnings_.pop();
    }
    void clear_warnings() {
      while (!warnings_.empty())
        next_warning();
    }
  protected:
    // Attention: The warning parameter must have been created with
    // new - it will be deleted.
    void add_warning(SQLWarning *warning) {
      warnings_.push(warning);
    }
  private:
    std::queue<SQLWarning *> warnings_;
};

}

#endif
