/* This is for emacs: -*-Mode: C++;-*- */
/*  
  Copyright 2002, Andreas Rottmann

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public  License
  along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#if !defined(__INC_APP_H)
#define __INC_APP_H

#include <stdio.h>

#include <iostream>
#include <stdexcept>

#include "gql++/driver-manager.h"
#include "gql++/connection.h"

#include "print.h"

namespace GQLShell
{

class App : public SigC::Object
{
    enum
    {
      F_USE_READLINE = 0x0001,
      F_USE_HISTORY = 0x0002,
      F_PROMPT_PASSWD = 0x0004,
      F_INTERACTIVE = 0x0008
    };
    enum CmdStatus
    {
      CMD_STATUS_UNKNOWN = 0,
      CMD_STATUS_SEND,
      CMD_STATUS_SKIP_LINE,
      CMD_STATUS_TERMINATE,
      CMD_STATUS_NEWEDIT,
      CMD_STATUS_ERROR
    };
  public:
    enum PromptType
    {
      PROMPT_READY,
      PROMPT_CONTINUE,
      PROMPT_COMMENT,
      PROMPT_SINGLEQUOTE,
      PROMPT_DOUBLEQUOTE,
      PROMPT_PAREN,
      PROMPT_COPY
    };
    
    class CmdLineError : public std::runtime_error
    {
      public:
        CmdLineError(const std::string& msg) : runtime_error(msg) { }
    };
    class DBOpenError : public std::runtime_error
    {
      public:
        DBOpenError(const std::string& url, const std::string& msg) 
            : runtime_error(msg) { 
          url_ = url;
        }
        ~DBOpenError() throw () { }
        const std::string& url() const { return url_; }
      private:
        std::string url_;
    };
    class InputError : public std::runtime_error
    {
        InputError(const std::string& msg) : runtime_error(msg) { }
    };
    
    App(int argc, char *argv[]) throw (CmdLineError, DBOpenError);
    ~App();

    // Actions
    void list_drivers(std::ostream& os = std::cout);
    static void usage(std::ostream& os = std::cout);
    void slash_usage();
    static void print_copyright(std::ostream& os = std::cout);
    static void help_sql(const std::string& topic = std::string(), 
                         std::ostream& os = std::cout);
    void error(const char *fmt, ...);
    
    // Settings
    bool get_variable_bool(const std::string& var) const { return false; }
    bool variable_isset(const std::string& var) const { return false; }
    std::string get_variable(const std::string& var) const { return ""; }
    
    bool use_readline() const { return flags_ & F_USE_READLINE; }
    bool use_history() const { return flags_ & F_USE_HISTORY; }
    bool prompt_passwd() const { return flags_ & F_PROMPT_PASSWD; }
    bool interactive() const { return flags_ & F_INTERACTIVE; }
    bool quiet() const { return get_variable_bool("QUIET"); }

    // prompt.cc
    std::string get_prompt(PromptType type = PROMPT_READY) const;
    
    // sprompt.cc
    std::string simple_prompt(const std::string& prompt, bool echo = true);
    
    int run();
  private:
    CmdStatus handle_slash_cmd(const std::string& line, std::string& query, 
                               std::string::size_type& end_of_cmd);
    CmdStatus exec_command(const std::string& cmd, 
                           const std::string& options_str,
                           std::string::size_type& continue_parse,
                           std::string& query);
    bool logger(int level, const std::string& msg);
    bool execute_query(const std::string& query);
    bool list_tables(const std::string& typeinfo, const std::string& name, 
                     bool desc);
    bool describe_table_details(const std::string& name, bool verbose);
    
    GQL::DriverManager dm_;
    GQL::Connection *conn_;
    std::string url_;
    std::string username_;
    std::string prompt_[3];
    std::string infile_;
    std::string progname_;
    std::string gfname_;
    TablePrinter tbl_printer_;
    ResultSetPrinter rs_printer_;
    int flags_;
    int verbosity_;
    int log_verbosity_;
    int cmd_;
    int lineno_;
    FILE *fout_;
};

}

#endif
