/* this file is an attempt to define a menu system applicable for both the gtk
 * and the Gnome version . The main goal of this file is to create a concept  
 * that can be used easily by both Gtk and Gnome. The functions defined     
 * here decide wether the gnome or the gtk variant is to be used on the   
 * HAVE_GNOME flag defined in config.h */    

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>    
#include <string.h>     

#include "config.h"
#include "int.h"

#ifdef HAVE_GNOME
#include <gnome.h>
#endif

#include "menusys.h"

/* include the Gnome/Gtk specific parts */
#ifdef HAVE_GNOME   
# include "menusys.gnome.c"       
#else      
# include "menusys.gtk.c"    
#endif        

/* belonging to all items */
typedef struct 
{
   menusys_menu *ourmenu;
   menusys_popupcallback cb;
   gpointer data;
   int free_choice;
   
   GList *private_bits;
} menusys_popupglobal;

/* belonging only to a particular item */
typedef struct 
{
   menusys_popupglobal *parent;
   gpointer choice;
} menusys_private;

void menusys_internal_popupcallback(GtkWidget *w,gpointer data)
{  
   /* use a hack for the Gnome version here. The Gtk Version
    * can be used just normally with the usual user_data scheme 
    * but Gnome only allows one user_data item to be passed to all
    * the menu items which makes them effectively indistinguishable.
    * So for Gnome, we're setting a special data entry for the menuitem
    * widget representing our selected entry.
    * This is done in menusys_dopopup.
    * We don't have to use a compiled switch *here*. Our hack is
    * activated automtically if we receive NULL as our data parameter */
   menusys_private *p=     
     (menusys_private*)
     ((!data)?gtk_object_get_data(GTK_OBJECT(w),
				 "menusys_privatedata")
       :data);
   menusys_popupglobal *info=NULL;
     
   if (!p)
     {	
	printf ("Assertion failed (p!=NULL) in menusys_internal_popupcallback() \n");
	printf ("Object at %p doesn't possess \'menusys_privatedata\' \n",w);
	printf ("Please file a bug report and send it to A.Eckleder@bigfoot.com\n");
     }
   else
     {	
	info=p->parent;

	/* call callback handler */
	info->cb(p->choice,	
		 info->data);
	
	/* clear private callback items */
	while (info->private_bits)
	  {
	     /* free "choice" if requested */
	     if (info->free_choice)
	       free(((menusys_private*)(info->private_bits->data))->choice);
	     free(info->private_bits->data);
	     info->private_bits=g_list_remove(info->private_bits,
					      info->private_bits->data);
	  };
	/* and off we go */
	free(info->ourmenu);
	free(info);
     };
};

/* create a menu structure suitable for use with any standard
 * Gnome Gtk Menu functions from a gtoaster dynamic menu structure.
 * This is used to call a single callback with multiple arguments */
menusys_menu *menusys_createpopupwithsinglecallback(menusys_popupcallback cb,
						    gpointer data,   
						    int free_choice,  
						    int entries,
						    menusys_dynmenu_entry *menu)
{
   menusys_popupglobal *info=(menusys_popupglobal*)malloc(sizeof(menusys_popupglobal));
   int x;

   info->cb=cb;
   info->data=data;
   info->free_choice=free_choice;
   info->private_bits=NULL;

   info->ourmenu=(menusys_menu*)malloc(sizeof(menusys_menu)*(entries+1));
   for (x=0;x<entries;x++)
     {
	char *label=menu[x].label;
	gpointer choice=menu[x].choice;
	menusys_private *p=(menusys_private*)malloc(sizeof(menusys_private));
	
	p->parent=info;
	p->choice=choice;	

	/* dynamic menus are a bit of a mess. We have to deal with
	 * the menuinfo structs ourselves cause you can't use the macros
	 * for dynamic menu creation */

#ifdef HAVE_GNOME
	info->ourmenu[x].type=GNOME_APP_UI_ITEM;
	info->ourmenu[x].label=label;
	info->ourmenu[x].hint="";
	info->ourmenu[x].moreinfo=menusys_internal_popupcallback;
	info->ourmenu[x].user_data=p;
	info->ourmenu[x].unused_data=NULL;
	info->ourmenu[x].pixmap_type=GNOME_APP_PIXMAP_NONE;
	info->ourmenu[x].pixmap_info=NULL;
	info->ourmenu[x].accelerator_key=0;
	info->ourmenu[x].ac_mods=0;
	info->ourmenu[x].widget=NULL;
#else
	info->ourmenu[x].title=label;
	info->ourmenu[x].tooltip="";
	info->ourmenu[x].callback=menusys_internal_popupcallback;
	info->ourmenu[x].data=p;
	info->ourmenu[x].pixmapdata=NULL;
#endif
	info->private_bits=g_list_append(info->private_bits,(gpointer)p);
     };
   /* Terminate menu */
#ifdef HAVE_GNOME
   info->ourmenu[entries].type=GNOME_APP_UI_ENDOFINFO;
#else
   info->ourmenu[entries].title=NULL;
   info->ourmenu[entries].tooltip=NULL;
   info->ourmenu[entries].callback=NULL;
   info->ourmenu[entries].data=NULL;
   info->ourmenu[entries].pixmapdata=NULL;
#endif
   return info->ourmenu;
};
	

void menusys_popupwithsinglecallback(menusys_popupcallback cb,   
				     gpointer data,   
				     int free_choice,  
				     int entries,
				     menusys_dynmenu_entry *menu)
{
   /* we don't provide a data pointer here because every individual 
    * menu entry has it's own in this context */
   menusys_dopopup(menusys_createpopupwithsinglecallback(cb,data,free_choice,entries,menu),
		   NULL);
};

typedef struct
{
   menusys_dynmenuprovider p;
   gpointer data;
   gpointer userdata;
} menusys_dynpopupinfo;

static void menusys_displaydynpopupcb(GtkWidget *w,
				      GdkEventButton *event,
				      gpointer data)
{
   menusys_dynpopupinfo *info=(menusys_dynpopupinfo*)data;
   /* popup menu if Button 3 was pressed */
   if (event->button==3)
	menusys_dopopup(info->p(info->data),info->userdata);
};  

/* Install dynamic popup menu */
void menusys_attachdynamicpopupmenu(GtkWidget*w,
				    gpointer userdata,
				    menusys_dynmenuprovider p,
				    gpointer data)
{
   menusys_dynpopupinfo *info=(menusys_dynpopupinfo *)malloc(sizeof(menusys_dynpopupinfo));
   info->p=p;
   info->data=data;
   info->userdata=userdata;
   gtk_signal_connect(GTK_OBJECT(w),"button_press_event",
		      GTK_SIGNAL_FUNC(menusys_displaydynpopupcb),info);
};
   
