/***************************************************************************
                          guidedog.h  -  description
                             -------------------
    begin                : Thu Sep 27 22:23:16 CEST 2001
    copyright            : (C) 2001 by Simon Edwards
    email                : simon@simonzone.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUIDEDOG_H
#define GUIDEDOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kdialogbase.h>
#include <qwidget.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qvgroupbox.h>
#include <qcheckbox.h>
#include <qvalidator.h>
#include <qradiobutton.h>
#include <kaboutapplication.h>
#include <klistview.h>
#include <keditcl.h>
#include <kcombobox.h>
#include <knuminput.h>
#include "simelineedit.h"

#include "guidedogdoc.h"

#define SYSTEM_RC_GUIDEDOG "/etc/rc.guidedog"

class AddressValidator : public QValidator {
    Q_OBJECT
public:
    AddressValidator(QWidget *parent=0,const char *name=0);
    ~AddressValidator();

    virtual QValidator::State validate(QString &input, int &pos) const;
    virtual void fixup(QString &input) const;
};

class IPValidator : public QValidator {
    Q_OBJECT
public:
    IPValidator(QWidget *parent=0,const char *name=0);
    ~IPValidator();

    virtual QValidator::State validate(QString &input, int &pos) const;
    virtual void fixup(QString &input) const;
};

/** Guidedog is the base class of the project */
class GuidedogApp : public KDialogBase
{
    Q_OBJECT
public:
        /** construtor */
    GuidedogApp(const QString &caption);
        /** destructor */
    ~GuidedogApp();

    bool initialise(bool god);
	void openDefault();
    bool applyScript(bool warnfirst);
    bool resetSystemConfiguration();

protected:
    void saveOptions();
    void readOptions();

public slots:
    void slotOk();
    void slotApply();
    void slotCancel();
    void slotUser1();
    void slotRouting(bool on);
    void slotMasquerade(bool on);
    void slotMasqueradeFTP(bool on);
    void slotMasqueradeIRC(bool on);
    void slotDisableGuidedog(bool on);
    void slotImportButton();
    void slotExportButton();
    void slotDescriptionChanged();

    void slotNoMasqueradeListBox(QListBoxItem *item);
    void slotNewAddressButton();
    void slotDeleteAddressButton();
    void slotAddressLineEdit(const QString &s);
    void slotAddressLineEditReturn();

    void slotForwardListBox(QListBoxItem *item);
    void slotNewForwardButton();
    void slotDeleteForwardButton();

    void slotOriginalPortSpinBox(int x);
    void slotOriginalMachineRadio(bool on);
    void slotOriginalSpecifyRadio(bool on);    
    void slotOriginalSpecifyLineEdit(const QString &);

    void slotPortProtocolComboBox(int x);

    void slotNewMachineRadio(bool on);
    void slotNewSpecifyRadio(bool on);
    void slotNewSpecifyLineEdit(const QString &s);
    void slotNewPortSpinBox(int x);

    void slotCommentLineEdit(const QString &);
                 
private:
    bool superusermode;
    bool systemconfigmodified;
	bool waspreviousconfiguration;

    GuidedogDoc *doc;
    bool updatinggui;

    void syncGUIFromDoc();

    void enabledGUIStuff();
    void setForwardRule(GuidedogPortForwardRule *rule);
    
        // Routing
    QVBox *routingpage;
    QCheckBox *routingcheckbox;
    QCheckBox *masqueradecheckbox;
    QCheckBox *masqueradeftpcheckbox;
    QCheckBox *masqueradeirccheckbox;

    KListBox *nomasqlistbox;
    SimeLineEdit *nomasqlineedit;
    AddressValidator *addressvalidator;
    QPushButton *newnomasqbutton;
    QPushButton *deleteenomasqbutton;
        
        // Forwarding
    QVBox *forwardingpage;
    KListBox *forwardlistbox;
    QPushButton *newforwardbutton;
    QPushButton *deleteforwardbutton;

    KIntSpinBox *originalportspinbox;
    KComboBox *portprotocolcombobox;
    QRadioButton *originalthismachineradio;
    QRadioButton *originalspecifyradio;
    SimeLineEdit *originalspecifylineedit;
    IPValidator *originalspecifyaddressvalidator;
    
    KIntSpinBox *newportspinbox;
    QRadioButton *newthismachineradio;
    QRadioButton *newspecifyradio;
    SimeLineEdit *newspecifylineedit;
    IPValidator *newspecifyaddressvalidator;

    SimeLineEdit *commentlineedit;
            
        // Advanced
    QVBox *advancedpage;
    QCheckBox *disablecheckbox;
    QPushButton *importbutton;
    QPushButton *exportbutton;
    KEdit *descriptionedit;

    KAboutApplication *aboutus;

    QSize commandrunnersize;

};

#endif
