/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Thu Sep 27 22:23:16 CEST 2001
    copyright            : (C) 2001 by Simon Edwards
    email                : simon@simonzone.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <unistd.h>
#include <kmessagebox.h>

#include "guidedog.h"
	
static KCmdLineOptions options[] =
{
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[]) {

    KAboutData aboutData( "guidedog", I18N_NOOP("Guidedog"),
        VERSION, I18N_NOOP("Advanced Networking utility"), KAboutData::License_GPL,
        "(c) 2001-2003, Simon Edwards",
        I18N_NOOP("Utility for easily configuring advanced networking features."),
        "http://www.simonzone.com/software/guidedog/");
    aboutData.addAuthor("Simon Edwards",I18N_NOOP("Developer"), "simon@simonzone.com","http://www.simonzone.com/");
    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

    KApplication a;
    GuidedogApp *guidedog = new GuidedogApp(i18n("Advanced Network Configuration"));
    if(guidedog->initialise(getuid()==0)) {
        if(getuid()!=0) {
            KMessageBox::information(0,i18n(
                "Since you do not have superuser privilages, Guidedog is\n"
                "running with reduced functionality. Scripts may be \n"
                "Imported/Exported, but  the system's networking settings\n"
                "may not be changed.\n"),QString::null,QString("MORTALMODEWARNING"));
        }
        guidedog->exec();
    }
    delete guidedog;
    return 0;
}
