/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2004 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef GF_THEME_H
#define GF_THEME_H

#define GF_THEME(theme) 		((GfTheme *)theme)
#define GF_THEME_API_VERSION 	(1)

typedef struct _GfTheme			GfTheme;

#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include "account.h"
#include "blist.h"
#include "conversation.h"

#include "gf_event_info.h"
#include "gf_item.h"
#include "gf_theme_info.h"
#include "gf_theme_ops.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

GfTheme *gf_theme_new();
GfTheme *gf_theme_new_from_file(const gchar *filename);
void gf_theme_destory(GfTheme *theme);

GfTheme *gf_theme_find_theme_by_name(const gchar *name);
gboolean gf_theme_save_to_file(GfTheme *theme, const gchar *filename);
GfTheme *gf_theme_find_theme_by_filename(const gchar *filename);
gchar *gf_theme_strip_name(GfTheme *theme);

gboolean gf_theme_is_loaded(const gchar *filename);
gboolean gf_theme_is_probed(const gchar *filename);
void gf_theme_load(const gchar *filename);
void gf_theme_unload(GfTheme *theme);
void gf_theme_probe(const gchar *filename);
void gf_theme_unprobe(const gchar *filename);
void gf_themes_probe();
void gf_themes_unprobe();

gint gf_theme_get_api_version(GfTheme *theme);
const gchar *gf_theme_get_filename(GfTheme *theme);
const gchar *gf_theme_get_path(GfTheme *theme);
gchar *gf_theme_get_supported_notifications(GfTheme *theme);
void gf_theme_set_theme_info(GfTheme *theme, GfThemeInfo *info);
GfThemeInfo *gf_theme_get_theme_info(GfTheme *theme);
void gf_theme_set_theme_options(GfTheme *theme, GfThemeOptions *ops);
GfThemeOptions *gf_theme_get_theme_options(GfTheme *theme);

void gf_theme_add_notification(GfTheme *theme, GfNotification *notification);
void gf_theme_remove_notification(GfTheme *theme, GfNotification *notification);
GList *gf_theme_get_notifications(GfTheme *theme);

GList *gf_themes_get_all();
GList *gf_themes_get_loaded();
void gf_themes_unload();
void gf_themes_save_loaded();
void gf_themes_load_saved();

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GF_THEME_H */
