module Data.IORef
  ( 
   -- * IORefs
    IORef                -- abstract, instance of: Eq, Typeable
  , newIORef             -- :: a -> IO (IORef a)
  , readIORef            -- :: IORef a -> IO a
  , writeIORef           -- :: IORef a -> a -> IO ()
  , modifyIORef          -- :: IORef a -> (a -> a) -> IO ()
--  , atomicModifyIORef    -- :: IORef a -> (a -> (a,b)) -> IO b

  ) where

import Data.IORefBuiltin
import PreludeBuiltinTypes
--import TraceOrigData.IORef 
import qualified TraceOrigData.IORef

foreign import haskell "Data.IORef.newIORef"
  newIORef              :: a -> IO (IORef a)
foreign import haskell "Data.IORef.readIORef"
  readIORef             :: IORef a -> IO a
foreign import haskell "Data.IORef.writeIORef"
  writeIORef            :: IORef a -> a -> IO ()
foreign import haskell "Data.IORef.modifyIORef"
  modifyIORef           :: IORef a -> (a->a) -> IO ()

--foreign import haskell "Data.IORef.atomicModifyIORef"
--  atomicModifyIORef     :: IORef a -> (a->(a,b)) -> IO b

