// -*- C++ -*-

#ifndef _ALIGNEDSUPERBLOCKHEAP_H_
#define _ALIGNEDSUPERBLOCKHEAP_H_

#include "mmapheap.h"

#include "conformantheap.h"
#include "lockedheap.h"
#include "fixedrequestheap.h"

#if defined(_WIN32)
#include "winmmapheap.h"

// FIX ME : magic 256K number below...

template <class TheLockType,
	  size_t SuperblockSize>
class AlignedSuperblockHeap :
  public ConformantHeap<LockedHeap<TheLockType,
  FixedRequestHeap<SuperblockSize, 
  WinMmapHeap<SuperblockSize, 256 * 1024> > > > {};

#else

// Always requests aligned superblocks.
#include "alignedmmap.h"

template <class TheLockType,
	  size_t SuperblockSize>
class AlignedSuperblockHeap :
  public ConformantHeap<LockedHeap<TheLockType,
  FixedRequestHeap<SuperblockSize, 
  AlignedMmap<SuperblockSize, HL::MmapHeap> > > > {};

#endif

#endif
