// chart.c
// -----------
//		Copyright 1988 D.C. Lindsay at Carnegie Mellon University
//
// Implementation of class: see chart.h for specs.

#include "machine.h"
#include "chart.h"
#include <stdlib.h>
#include <stream.h>

chartclass::chartclass( int rangesizearg )
{
	rangesize = rangesizearg;
	for( int i = 0; i < MAX_CHART_LEN; i++ ) counts[i] = 0;
	eventcount = 0;
}
/************************************/
void chartclass::reset()
{
//	int maxi;
//	for( maxi = MAX_CHART_LEN-1; maxi > 0; maxi-- )
//		if( counts[maxi] ) break;	// beyond here is 0
//	if( (10*maxi+10) <= (MAX_CHART_LEN) )
//		if( rangesize > 10 )
//			rangesize /= 10;
//
	for( int i = 0; i < MAX_CHART_LEN; i++ ) counts[i] = 0;
	eventcount = 0;
}
/************************************/
void chartclass::reset( int rangesizearg )
{
	rangesize = rangesizearg;
	for( int i = 0; i < MAX_CHART_LEN; i++ ) counts[i] = 0;
	eventcount = 0;
}
/************************************/
void chartclass::note( int value )
{
	int index = value / rangesize;
	if( index < 0) {
		cout << "ERROR in chart::note - "
			<< value << " out of range.\n";
		exit(1);
	}
	if( index >= MAX_CHART_LEN ) index = MAX_CHART_LEN-1;
	counts[ index ]++;
	eventcount++;
}
/************************************/

void chartclass::print( char *label )
{
	if( eventcount == 0 ) return;
	cout	<< label << " on " << eventcount << " events.\n"
		<< " Each bucket is " << rangesize << " units:";
	int maxi;
	for( maxi = MAX_CHART_LEN-1; maxi > 0; maxi-- )
		if( counts[maxi] ) break;
	for( int i = 0; i <= maxi; i++ ) {
		if( (i%25)==0 ) cout NL;
		cout << " " << counts[i];
	}
	cout NL;
}
