/* $Log: calloc-malloc.c,v $
/* Revision 1.1  2003/10/15 15:58:50  emery
/* Initial check-in.
/*
/* Revision 1.3  2003/05/08 21:42:29  emery
/* Ritual check-in.
/*
/* Revision 1.2  2001/11/08 22:48:22  emery
/* Added stuff for vmalloc.
/*
/* Revision 1.1  2001/08/23 17:19:36  emery
/* The big fig newton.
/*
/* Revision 1.1.1.1  2001/06/28 19:48:20  dgay
/* Initial import of RC tests
/*
 * Revision 1.5  1997/08/04 22:16:44  arda
 * Fix mudlle so that it compiles with g++
 *
 * Revision 1.4  1996/02/09 14:58:10  arda
 * Security holes
 *
 * Revision 1.3  1993/05/02  07:37:37  un_mec
 * Owl: New output (mudlle ports).
 *
 * Revision 1.2  1993/03/29  09:23:37  un_mec
 * Owl: Changed descriptor I/O
 *      New interpreter / compiler structure.
 *
 * Revision 1.3  1993/03/14  16:13:53  dgay
 * Optimised stack & gc ops.
 *
 * Revision 1.1  1992/12/27  21:40:55  un_mec
 * Mudlle source, without any Mume extensions.
 *
 */

#if USE_REAP==1 && defined(_WIN32)
#pragma comment(lib, "libreap.lib")
#endif

static char rcsid[] = "$Id: calloc-malloc.c,v 1.1 2003/10/15 15:58:50 emery Exp $";

#include <stdlib.h>
#include <stdio.h>
#ifdef MUME
#include <malloc.h>
#endif
#include "mudlle.h"
#include "calloc.h"
#include "utils.h"


/* Point to other region implementations. */

#if USE_EMERY_HEAP

#define USE_WIN32_HEAP 0
#define USE_VMALLOC 0

#if (USE_VMALLOC + USE_WIN32_HEAP > 1)
#error "Oops-a-daisy."
#endif


#if USE_VMALLOC

#include <vmalloc.h>

void regionCreate (void ** reg, void ** parent) {
  Vmalloc_t * vm = vmopen(Vmdcheap, Vmbest, VM_TRUST);
//  Vmalloc_t * vm = vmopen(Vmdcsbrk, Vmbest, VM_TRUST);
  *((Vmalloc_t **) reg) = vm;
}

void regionDestroy (void ** reg) {
  vmclose ((Vmalloc_t *) *reg);
}

void * regionAllocate (void ** reg, size_t sz) {
  return vmalloc ((Vmalloc_t *) *reg, sz);
}

void regionFreeAll (void ** reg) {
  vmclear ((Vmalloc_t *) *reg);
}
#endif


#if USE_WIN32_HEAP

#include <windows.h>

void regionCreate (void ** reg, void ** parent) {
	HANDLE h = HeapCreate(HEAP_NO_SERIALIZE,0,0);
	*((HANDLE *) reg) = h;
}

void regionDestroy (void ** reg) {
	HeapDestroy(*((HANDLE *) reg));
}

void * regionAllocate (void ** reg, size_t sz) {
	return HeapAlloc(*((HANDLE *) reg), 0, sz);
}

void regionFreeAll (void ** reg) {
	HeapDestroy(*((HANDLE *) reg));
	*((HANDLE *) reg) = HeapCreate(HEAP_NO_SERIALIZE,0,0);
}

#else

	extern void regionCreate (void ** reg, void ** parent);
	// extern void regionCreate (void ** reg);
	extern void regionDestroy (void ** reg);
	extern void * regionAllocate (void ** reg, size_t sz);
	extern void regionFreeAll (void ** reg);

#endif

/* block_t is equivalent to void *. */

block_t new_block(void)
{
	block_t bl = (block_t) xmalloc(sizeof(bl));
	//	printf ("size of bl = %d\n", sizeof(block_t));
	regionCreate (&bl, NULL);
//	regionCreate (&bl);
	return bl;
}

void *allocate(block_t b, unsigned long size)
{
	return regionAllocate (&b, size);
}

void free_block(block_t b)
{
//	printf ("free_block baby!\n");
//	regionFreeAll (&b);
	regionDestroy (&b);
	free (b);
}


#else

struct memblock
{
  struct memblock *next;
  char data[1];
};

block_t new_block(void)
/* Return: A new block from which to allocate some memory.
*/
{
  block_t newp = xmalloc(sizeof *newp);

  *newp = NULL;
  return newp;
}

void free_block(block_t b)
/* Effect: Free all memory allocated in block b.
*/
{
  struct memblock *blk = *b;

  while (blk)
    {
      struct memblock *prev = blk->next;

      free(blk);
      blk = prev;
    }
}

void *allocate(block_t b, unsigned long size)
/* Effects: Allocates size bytes from block b. The result is aligned
     correctly for all types.
   Returns: A pointer to the start of the block.
   Note: In this implementation, 12 + average(size)/2 bytes will be wasted
     for every BLOCK_SIZE bytes allocated.
*/
{
  struct memblock *x = xmalloc(size + sizeof(struct mem *));

  x->next = *b;
  *b = x;

  return x->data;
}

#endif
