/* $Log: tree.h,v $
/* Revision 1.1  2003/10/15 15:59:00  emery
/* Initial check-in.
/*
/* Revision 1.1  2001/08/23 17:20:25  emery
/* The big fig newton.
/*
/* Revision 1.1.1.1  2001/06/28 19:48:19  dgay
/* Initial import of RC tests
/*
 * Revision 1.13  1997/08/04 22:17:21  arda
 * Fix mudlle so that it compiles with g++
 *
 * Revision 1.12  1996/02/09 14:59:00  arda
 * Security holes
 *
 * Revision 1.11  1994/10/09  06:43:06  arda
 * Libraries
 * Type inference
 * Many minor improvements
 *
 * Revision 1.10  1994/08/16  19:16:25  arda
 * Mudlle compiler for sparc now fully functional (68k compiler now needs
 * updating for primitives).
 * Changes to allow Sparc trap's for runtime errors.
 * Also added flags to primitives for better calling sequences.
 *
 * Revision 1.7  1994/02/24  08:33:09  arda
 * Owl: New error messages.
 *
 * Revision 1.6  1994/01/29  19:50:39  dgay
 * Owl: add file & line information to functions.
 *
 * Revision 1.5  1993/08/15  21:00:32  un_mec
 * Owl: Overload [].
 *      Added xcalloc, xrealloc.
 *
 * Revision 1.4  1993/07/21  20:37:02  un_mec
 * Owl: Added &&, ||, optimised if.
 *      Added branches to the intermediate language.
 *      Separated destiniation language generation into ins module
 *      (with some peephole optimisation)
 *      Standalone version of mudlle (mkf, runtime/mkf, mudlle.c) added to CVS
 *
 * Revision 1.3  1993/03/29  09:24:44  un_mec
 * Owl: Changed descriptor I/O
 *      New interpreter / compiler structure.
 *
 * Revision 1.3  1993/03/14  16:15:08  dgay
 * Optimised stack & gc ops.
 *
 * Revision 1.1  1992/12/27  21:41:40  un_mec
 * Mudlle source, without any Mume extensions.
 *
 */

#ifndef TREE_H
#define TREE_H

#include <stdio.h>
#include "calloc.h"

extern block_t parser_memory;

typedef struct _component *component;
typedef struct _constant *constant;

typedef struct _vlist {
  struct _vlist *next;
  const char *var;
  mtype type;
} *vlist;

typedef struct _clist {
  struct _clist *next;
  component c;
} *clist;

typedef struct _cstlist {
  struct _cstlist *next;
  constant cst;
} *cstlist;

typedef struct {
  mtype type;			/* Return type */
  const char *help;
  vlist args;			/* Stored in reverse order! */
  int varargs;			/* TRUE if accepts arg vector (==> length(vargs)=1) */
  component value;
  int lineno;
  const char *filename;
  const char *varname;		/* Name of variable in which function is stored */
} *function;

typedef struct {
  vlist locals;
  clist sequence;
} *block;

enum constant_class { cst_int, cst_string, cst_list, cst_array };

struct _constant {
  enum constant_class vclass;
  union {
    int integer;
    const char *string;
    cstlist constants;	/* Stored in reverse order ... */
  } u;
};

enum {
  b_or, b_and, b_sc_or, b_sc_and, b_eq, b_ne, b_lt, b_le, b_gt, b_ge,
  b_bitor, b_bitxor, b_bitand, b_shift_left, b_shift_right,
  b_add, b_subtract, b_multiply, b_divide, b_remainder, b_negate,
  b_not, b_bitnot, b_ifelse, b_if, b_while, b_loop, b_ref, b_set,
  b_cons, last_builtin
};

enum component_class {
  c_assign, c_recall, c_constant, c_closure, c_execute, c_builtin, c_block,
  c_labeled, c_exit 
};

struct _component {
  enum component_class vclass;
  union {
    struct {
      const char *symbol;
      component value;
    } assign;
    const char *recall;
    constant cst;
    function closure;
    clist execute;		/* 1st element is fn, rest are args */
    struct {
      unsigned int fn;
      clist args;
    } builtin;
    block blk;
    struct {
      const char *name;
      component expression;
    } labeled; /* also for exit */
  } u;
};

enum file_class { f_plain, f_module, f_library };

typedef struct {
  enum file_class vclass;
  const char *name;
  vlist imports;
  vlist defines;
  vlist reads;
  vlist writes;
  block body;
} *mfile;

mfile new_file(block_t heap, enum file_class vclass, const char *name,
	       vlist imports, vlist defines, vlist reads, vlist writes,
	       block body);
function new_function(block_t heap, mtype type, const char *help, vlist args,
		      component value, int lineno, const char *filename);
function new_vfunction(block_t heap, mtype type, const char *help,
		       const char *arg, component value,
		       int lineno, const char *filename);
block new_codeblock(block_t heap, vlist locals, clist sequence);
clist new_clist(block_t heap, component c, clist next);
cstlist new_cstlist(block_t heap, constant cst, cstlist next);
vlist new_vlist(block_t heap, const char *var, mtype type, vlist next);
constant new_constant(block_t heap, enum constant_class vclass, ...);
component new_component(block_t heap, enum component_class vclass, ...);
#ifdef PRINT_CODE
void print_file(FILE *out, mfile f);
#endif

clist append_clist(clist l1, clist l2);
clist reverse_clist(clist l);
cstlist reverse_cstlist(cstlist l);
vlist append_vlist(vlist l1, vlist l2);
vlist reverse_vlist(vlist l);

value mudlle_parse(block_t heap, mfile f);

#endif
