/* -*- C++ -*- */

#ifndef _FREELISTHEAP_H_
#define _FREELISTHEAP_H_

/**
 * @class FreelistHeap
 * @brief Manage freed memory on a linked list.
 * @warning This is for one "size class" only.
 * 
 * Note that the linked list is threaded through the freed objects,
 * meaning that such objects must be at least the size of a pointer.
 */

#include <assert.h>

namespace HL {

template <class SuperHeap>
class FreelistHeap : public SuperHeap {
public:
  
  inline FreelistHeap (void)
    : myFreeList (NULL)
    {}

  inline ~FreelistHeap (void)
    {
#if 0
      // Delete everything on the free list.
      void * ptr = myFreeList;
      while (ptr != NULL) {
	// assert (nObjects > 0);
	assert (ptr != NULL);
	void * oldptr = ptr;
	ptr = (void *) ((freeObject *) ptr)->next;
	SuperHeap::free (oldptr);
      }
#endif
    }

  inline void * malloc (const size_t sz) {
    // Check the free list first.
    void * ptr = myFreeList;
    if (ptr == NULL) {
      ptr = SuperHeap::malloc (sz);
    } else {
      myFreeList = myFreeList->next;
    }
    return ptr;
  }
  
  inline void free (void * ptr) {
    // Add this object to the free list.
    assert (ptr != NULL);
    (reinterpret_cast<freeObject *>(ptr))->next = myFreeList;
    myFreeList = reinterpret_cast<freeObject *>(ptr);
  }

  inline void clear (void) {
    myFreeList = NULL;
    SuperHeap::clear();
  }

private:

  /// The linked list pointer we embed in the freed objects.
  class freeObject {
  public:
    freeObject * next;
  };

  /// The head of the linked list of freed objects.
  freeObject * myFreeList;

};

}

#endif
