# /usr/lindsay/cube/sim/makefile

#//		Copyright 1988 D.C. Lindsay at Carnegie Mellon University

# setenv MICC 1 makes CC use MICC (except for nm -p??)
#CC=MICC
CC=CC

LDFLAGS=
LIBFLAGS=
# define KSEARCH to get k, not k(k-1)
# the following gives trace info from the scheduler.
#CCFLAGS = -c -DDOMESG -DDOSCHED

#CCFLAGS = -c -DDOMESG
CCFLAGS = -c -O -DDOMESG -I/usr/include/cxx
#CCFLAGS = -c -g -DDOMESG +i

# the following leaves "gmon.out" at run time: run "gprof".
#CCFLAGS = -c -pg -DDOMESG
#LDFLAGS = -pg -t
#LDFLAGS = -r1
#LIBFLAGS = -lc_p
# the following leaves a .d for each .cxx file. Use "tcov".
#CCFLAGS = -c -a -DDOMESG

INCLUDES = machine.h sched.h node.h statistics.h measure.h xrand.h histogram.h chart.h choose.h
SOURCES = sim.cxx sched.cxx statistics.cxx measure.cxx xrand.cxx histogram.cxx chart.cxx choose.cxx message.cxx xgen.cxx
# the next doesn't include choose.o
OBJECTS = sim.o sched.o statistics.o measure.o xrand.o histogram.o chart.o message.o xgen.o
OBJECTSK = simk.o sched.o statistics.o measure.o xrand.o histogram.o chart.o message.o xgen.o
OBJECTS2 = sim2.o sched.o statistics.o measure.o xrand.o histogram.o chart.o message.o xgen.o
OBJECTSHARD = sim.o sched.o statistics.o measure.o xrand.o histogram.o chart.o messagehard.o xgen.o
OBJECTSSOFT = sim.o sched.o statistics.o measure.o xrand.o histogram.o chart.o messagesoft.o xgen.o

.SUFFIXES:	.cxx
.cxx.o:
	$(CC) $(CCFLAGS) $*.cxx

.c.o:
	$(CC) $(CCFLAGS) $*.c

sim:	$(OBJECTS) choose.o
	$(CC) -o sim $(LDFLAGS) $(OBJECTS) choose.o -lm $(LIBFLAGS)
choose.o: choose.c $(INCLUDES)

simk:	$(OBJECTSK) choose.o
	$(CC) -o simk $(LDFLAGS) $(OBJECTSK) choose.o -lm $(LIBFLAGS)

sim2:	$(OBJECTS2) choose.o
	$(CC) -o sim2 $(LDFLAGS) $(OBJECTS2) choose.o -lm $(LIBFLAGS)
sim2.o: sim2.c $(INCLUDES)

simhard:	$(OBJECTSHARD) choose.o
	$(CC) -o simhard $(LDFLAGS) $(OBJECTSHARD) choose.o -lm $(LIBFLAGS)
simsoft:	$(OBJECTSSOFT) choose.o
	$(CC) -o simsoft $(LDFLAGS) $(OBJECTSSOFT) choose.o -lm $(LIBFLAGS)


simlr:  $(OBJECTS) chooselr.o
	$(CC) -o simlr $(LDFLAGS) $(OBJECTS) chooselr.o -lm $(LIBFLAGS)
chooselr.o: chooselr.c $(INCLUDES)

simhigh:  $(OBJECTS) choosehigh.o
	$(CC) -o simhigh $(LDFLAGS) $(OBJECTS) choosehigh.o -lm $(LIBFLAGS)
choosehigh.o: choosehigh.c $(INCLUDES)

simdiff:  $(OBJECTS) choosediff.o
	$(CC) -o simdiff $(LDFLAGS) $(OBJECTS) choosediff.o -lm $(LIBFLAGS)
choosediff.o: choosediff.c $(INCLUDES)

simage:  $(OBJECTS) chooseage.o
	$(CC) -o simage $(LDFLAGS) $(OBJECTS) chooseage.o -lm $(LIBFLAGS)
chooseage.o: chooseage.c $(INCLUDES)

simset:  $(OBJECTS) chooseset.o
	$(CC) -o simset $(LDFLAGS) $(OBJECTS) chooseset.o -lm $(LIBFLAGS)
chooseset.o: chooseset.c $(INCLUDES)

xrand.o: xrand.c
	cc -c -O xrand.c
xgen.o: xgen.c ${INCLUDES}
message.o: message.c $(INCLUDES)
messagehard.o: messagehard.c $(INCLUDES)
messagesoft.o: messagesoft.c $(INCLUDES)
sim.o: sim.c $(INCLUDES)
simk.o: sim.c $(INCLUDES)
	$(CC) $(CCFLAGS) -DKSEARCH sim.c
	mv sim.o simk.o
#	$(CC) -o simk.o $(CCFLAGS) -DKSEARCH sim.c
sched.o: sched.c sched.h
measure.o: measure.c $(INCLUDES)
statistics.o: statistics.c statistics.h
histogram.o: histogram.c $(INCLUDES)

bak:
	cp README READMEbak makefile script*  *.c *.h xrand.o probe* run* backup
print:
	enscript README READMEbak makefile $(INCLUDES) $(SOURCES) runstd.right
test: sim
	sim < script.15 > out
	diff out script15.right
	sim < script.05 > out
	diff out script05.right
	sim < script.045 > out
	diff out script045.right
	sim < script.art > out
	diff out scriptart.right
	sim < script.artx > out
	diff out scriptartx.right
	sim < script.gen > out
	diff out scriptgen.right
	sim < script.05pull > out
	diff out script05pull.right
std: sim
	runscript script.std > out
	diff out runstd.right
diff:
	diff . backup
clean:
	rm -f *.o *.CKP *.BAK sim out core a.out
kleen:
	rm -f *.CKP *.BAK out core a.out
q:
	lpq -Pberyl
j: j.o 
	$(CC) -o j j.o -lm
