// measure.h
// ---------
//		Copyright 1988 D.C. Lindsay at Carnegie Mellon University
//
// Part of Hyperswitch simulation. Does measurements & related reporting.

#ifndef MEASURE_DEF
#define MEASURE_DEF 0

// You must have the following for this header to compile:
//#include "node.h"

enum finalstate{ 		// of a message
	failure, 		// dest busy
	nopaths,		// naks on all attempts
	sourcequit,		// source had no free links
	completeOK,		// done ok
	ignored			// wrongly generated, not sent
};
class measureclass {
public:
	measureclass();		// init

	SMessagePtr generate();	
				// create a message, or NULL,
				// in which case stop generating.
	void note( SMessagePtr, finalstate );
				// accumulate statistics on a message,
				// and then deallocate it.
	void runsize(int, int);
				// Sets message#s that measurement should
				// start and end at, eg 1 2 would mean that
				// counters reset after 1 message is noted.
				// After 2 more are noted, generate will
				// begin returning NULL, and a full print
				// is done.
				// If not called, default is 0, 10000.
	void finalize();	// Expects simulation has wound down to 0.
				// Does closeout checks, will print if
				// one hasn't been done.
};

#endif /* MEASURE_DEF */
