// messagesoft.c	message body that sends page by separate path, later.
// -------------
//		Copyright 1988 D.C. Lindsay at Carnegie Mellon University
//
// Implementation of the code contained in a message.

#include "node.h"
#include "sched.h"
extern schedulerclass scheduler;
#define NULL 0
extern int retry_count;
extern void messagerestart( int );

void messagebody( int ipm )
{
	struct message *pm = (struct message *)ipm;
	// This message has been delivered, and teardown has started.
	// If we set "reuse", teardown at the source won't cause the
	// message to be recorded/destroyed: this module can send it
	// places.
	pm-> reuse = true;

	// Note that the message size was small (8 bytes or so).
	// We must change this, since it's about to be a page, plus
	// a 16 byte header.
	pm-> length = 4224;

	// Swap the source and dest, so the page will go back to the source
	nodenum temp = pm-> source; 
	pm-> source = pm-> dest;
	pm-> dest = temp;

	// Insure the message doesn't run THIS when it gets there
	pm-> arrival = NULL;

	// The message has to have some initial conditions
	pm-> retrycount = retry_count;
	pm-> hopcount = 1;
	pm-> probecount = 1;

	// We can't act right now: host software is involved.
	scheduler.post( &messagerestart, ipm, RECEIVE_LATENCY );
}


