# used by hinfo, normally indirectly through /etc/hinfo.conf or ~/.hinforc
#
# Current version can be gotten from http://www.blars.org/hinfo/dnsbl.ins.pl
#
#	19 May 2004	remove reynolds
#	23 Nov 2003	add ahbl, remove summit/2mbit
#			remove easynet (going away dec 1)
#	18 Oct 2003	RIP monkeys.com, compu blackholes
#	17 Sep 2003	add l[12].spews.dnsbl.sorbs.net
#			remove exsila (dead?)
#	15 Sep 2003	Remove delink (dead)
#			fix typo in spl.spamhaus.org
#	 6 Sep 2003	Remove relays.osirusoft.com (dead)
#	16 Aug 2003	New BlarsBL code
#	13 Jul 2003	Long overdue updates based on www.declude.com
#			Many new lists, a few dead.
#			Some reordering, comment out osirusoft subdomains.
#	 4 Jun 2003	Remove dorkslayers (dead)
#	23 Apr 2003	Remove Dews (dead)
#			Minor fixes to BlarsBL explanations
#	 3 Nov 2002	Added contacts.abuse.net
#	24 Oct 2002	Added copyright notice
#	01 Oct 2002	Added @version
#
#
## This program is free software; you can redistribute it and/or modify
## it under the terms of the version 2 of the GNU General Public License 
## as published by the Free Software Foundation.  The license should
## be included in the file COPYING distributed with the source.
##


@version = (@version, "dnsbl.ins.pl 19 May 2004");

# list of DNSbl lists to consult
# for each DNS server:
#	["server", "name", "URL for info", \&explainsub,
#		[used by explainsub],],

@bhlists = (
# Blars Block List
	["block.blars.org", "Blars Block List", "www.blars.org/block.html",
	    \&explain_bitmask, [
		"Spam sending domain",
		"Multi-hop relay",
		"Dialups not in MAPS DUL",
		"Wants spam compainers to jump through hoops",
		"No working abuse address",
		"Hosts spamers web sites",
		"Hosts spammers email dropboxes",
		"breakin attempts",
		"sued a DNSbl",
		"DOS attack",
		"Spamware supplier",
		"Knowingly supports spammers",
		"Legal threats",
		"attepted mail relay",
		"attepted formmail exploit",
		"carreer spammer support",
		"",
		"provides connection to rogue isp",
		]],
# spamhaus
	["sbl.spamhaus.org", "spamhaus SBL",
	 	"www.spamhaus.org/", \&explain_txt, ],
# dsbl
	["list.dsbl.org", "DSBL", "dsbl.org/", ],
	["unconfirmed.dsbl.org", "DSBL unconfirmed", "dsbl.org/", ],
	["multihop.dsbl.org", "DSBL multihop", "dsbl.org/", ],
# ordb.org
	["relays.ordb.org", "ORDB open relays", "www.ordb.org/",
		\&explain_txt, "relays.ordb.org",],
# relays.osirusoft.com (dead)
#	["relays.osirusoft.com", "osirusoft relays", 
#	    "relays.osirusoft.com/", \&explain_iterate_txt, [
#		"",
#		"",
#		"Verified open relay",
#		"Dialup Spam Source",
#		"Confirmed Spam Source",
#		"Smart Host",
#		"Spamware developer",
#		"non-confirmed mailnglist",
#		"insecure formmail",
#		"open proxy",
#		]],
#	["dialups.osirusoft.com", "osirusoft dialups",
#		"relays.osirusoft.com/"],
#	["spamsites.osirusoft.com", "osirusoft spamsites", 
#		"relays.osirusoft.com/"],
#	["spamhaus.osirusoft.com", "osirusoft spamhaus",
#		"relays.osirusoft.com/"],
#	["outputs.osirusoft.com", "osirusoft outputs",
#		"relays.osirusoft.com/"],
# selwerd xbl
	["xbl.selwerd.cx", "selwerd XBL", "selwerd.cx/xbl/", \&explain_txt, ],
# dorkslayers orbs
#	["orbs.dorkslayers.com", "Dorkslayers ORBS", 
#		"www.dorkslayers.com/remove.html",],
#	["ztl.dorkslayers.com", "Dorkslayers ztl",],
# spamcop bl
	["bl.spamcop.net", "Spamcop BL", "spamcop.net/"],
# five-ten-sg
	["blackholes.five-ten-sg.com", "Five-Ten-SG Blackholes",
	    "www.five-ten-sg.com/blackholes.php", \&explain_iterate, [
		"",
		"",
		"spam source",
		"dialup",
		"bulk mailer",
		"multi-stage relay",
		"single-stage relay",
		"spam support",
		"insecure web proxy",
	]],
# spambag.org
	["blacklist.spambag.org", "SpamBag", "spambag.org/", \&explain_txt, ],
# visi.com relays (dead)
#	["relays.visi.com", "visi.com relays"],
# njabl
	["dnsbl.njabl.org", "njabl", "njabl.org/", \&explain_iterate, [
		"",
		"",
		"spam source or open relay",
		"dialup",
	]],
# rfc-ignorant.org
	["ipwhois.rfc-ignorant.org", "rfc-ignorant ipwhois", 
		"rfc-ignorant.org/"],
# compu
#	["blackhole.compu.net", "Compu",],
#	["pm0-no-more.compu.net", "Compu PM0 No-more",],
# dev.null.dk
	["dev.null.dk", "DK devnull", "www.fabel.dk/relay/",],
	["spamsources.fabel.dk", "DK spamsources",],
# flowgoaway
	["flowgoaway.com", "FloGoAway.com",],
# leadmon
	["spamguard.leadmon.net", "Leadmon spamguard",
		"www.leadmon.com/spamguard/", \&explain_iterate, [
		"",
		"",
		"dialup",
		"spam source",
		"bulk mailer",
		"open relay",
		"multi-stage relay",
		"spammer block",
		]],
# intersil
	["blackholes.intersil.net", "intersil blackholes",],
# kithrup
	["3y.spam.mrs.kithrup.com", "kithrup",],
# spamtr (dead)
#	["rbl.spam.org.tr", "Turkish spam list", "www.spam.org.tr/rbl/",],
# v6net
	["spammers.v6net.org", "v6net spammers",],
# summit
#	["blakholes.2mbit.com", "summit blocking list",
#		"www.2mbit.com/sbl.php",],
# wirehub (renamed to easynet)
#	["blackholes.wirehub.net", "Wirehub blackholes",
#		"basic.wirehub.nl/blackholes.html", ],
#	["dynablock.wirehub.net", "Wirehub Dynablock",
#		"basic.wirehub.nl/dynablocker.html", ],
# dews (dead)
#	["dews.qmail.org", "DEWS", "dews.qmail.org/", ],
# monkeys
#	["formmail.relays.monkeys.com", "Monkeys formmail",
#		"www.monkeys.com/anti-spam/filtering/formmail.html", ],
#	["proxies.relays.monkeys.com", "Monkeys proxies",
#		"www.monkeys.com/anti-spam/filtering/proxies.html", ],
# blitzed
	["opm.blitzed.org", "Blitzed", "www.blitzed.org/opm/",
	 	\&explain_txt, ],
# delink (dead)
#	["dnsbl.delink.net", "Delink", "dnsbl.delink.net/",
#	 	\&explain_txt, ],
# dnsrbl
	["dun.dnsrbl.net", "DNSRBL DUN", "www.dnsrbl.com/",],
	["spam.dnsrbl.net", "DNSRBL spam", "www.dnsrbl.com/",],
# nomorefunn
	["no-more-funn.moensted.dk", "NoMoreFunn",
	 	"www.moensted.dk/spam/no-more-funn.moensted.dk.txt/", 
		\&explain_txt, ],
# blackholes.us (not all .blackholes.us domains listed here)
	["verio.blackholes.us", "verio.blackholes.us", "www.blackholes.us/",
		\&explain_txt, ],
	["level3.blackholes.us", "level3.blackholes.us", "www.blackholes.us/",
		\&explain_txt, ],
	["cn-kr.blackholes.us", "cn-kr.blackholes.us", "www.blackholes.us/",
	 	\&explain_txt, ],
	["nigeria.blackholes.us", "nigeria.blackholes.us",
	 	"www.blackholes.us/", \&explain_txt, ],
# ybl
	["ybl.megacity.org", "Yahoo", "", \&explain_txt, ],
# deadbeaf
	["bl.deadbeef.com", "DeadBeef", "spam.deadbeef.com/bl/", ],
# easynet
#	["blackholes.easynet.nl", "easynet blackholes",
#	 	"blackholes.easynet.nl/", \&explain_txt, ],
#	["dynablock.easynet.nl", "easynet dynablock",
#	 	"dynablock.easynet.nl/", \&explain_txt, ],
# exsila
#	["spam.exsila.net", "exsila spam", "", \&explain_txt, ],
#	["proxies.exsila.net", "exsila proxies", "", \&explain_txt, ],
# jammconsulting
	["dnsbl.jammconsulting.com", "jammconsulting", "", \&explain_txt, ],
# kudenserver
	["relays.bl.kudenserver.de", "kudenserver",
	 	"relaytest.kudenserver.de", \&explain_txt, ],
# lagengymnasik
	["lbl.lagengymnastik.dk", "lagengymnastik",
	 	"lbl.lagengymnastik.dk/", \&explain_txt, ],
# nether
	["relays.nether.net", "nether", ],
# orid
	["dnsbl.antispam.or.id", "orid", "antispam.or.id/", \&explain_txt, ],
# n13mbl
	["relaywatcher.n13mbl.com", "n13mbl relaywatcher",
		"www.number13.com/relaywatcher/", \&explain_txt, ],
# reynolds
#	["t1.bl.reynolds.net.au", "reynolds", 
#		"bl.reynolds.net.au/t1/", \&explain_txt, ],
#	["ohps.bl.reynolds.net.au", "reynolds proxies", 
#		"bl.reynolds.net.au/ohps/", \&explain_txt, ],
#	["omrs.bl.reynolds.net.au", "reynolds multihop", 
#		"bl.reynolds.net.au/omrs/", \&explain_txt, ],
#	["osps.bl.reynolds.net.au", "reynolds socks", 
#		"bl.reynolds.net.au/osps/", \&explain_txt, ],
#	["osrs.bl.reynolds.net.au", "reynolds relays", 
#		"bl.reynolds.net.au/osrs/", \&explain_txt, ],
#	["owfs.bl.reynolds.net.au", "reynolds formmail", 
#		"bl.reynolds.net.au/owfs/", \&explain_txt, ],
#	["owps.bl.reynolds.net.au", "reynolds wingate", 
#		"bl.reynolds.net.au/owps/", \&explain_txt, ],
#	["rdts.bl.reynolds.net.au", "reynolds dynamic", 
#		"bl.reynolds.net.au/rdts/", \&explain_txt, ],
#	["ricn.bl.reynolds.net.au", "reynolds incorrect", 
#		"bl.reynolds.net.au/ricn/", \&explain_txt, ],
#	["rmst.bl.reynolds.net.au", "reynolds spamtraps", 
#		"bl.reynolds.net.au/rmst/", \&explain_txt, ],
# sbbl.they.com
	["sbbl.they.com", "they.com spambait", "", \&explain_txt, ],
# sorbs
	["dnsbl.sorbs.net", "sorbs", "www.dnsbl.sorbs.net/", \&explain_txt, ],
# spews
	["l1.spews.dnsbl.sorbs.net", "spews level 1", "www.spews.org/",
	 	\&explain_txt, ],
	["l2.spews.dnsbl.sorbs.net", "spews level 2", "www.spews.org/",
	 	\&explain_txt, ],
# technovision
	["bl.technovision.dk", "techonvision",
		"bl.technovision.dk/lookup.cgi", \&explain_txt, ], 
# uceb
	["bloackholes.uceb.org", "uceb", "www.uceb.org/", \&explain_txt, ],
# schpider
	["vox.schpider.com", "vox schpider", 
		"www.schpider.com/", \&explain_txt, ], 
# ahbl
	["dnsbl.ahbl.org", "ahbl", "www.ahbl.org/", \&explain_iterate, [
		"",
	        "",
		"open relay",
		"open proxy",
		"spam source",
		"provisional spam source",
		"formmail spam",
		"spam supporter",
		"indirect spam supporter",
		"end user (non-mail)",
		"shoot on sight",
		"missing postmaster or abuse",
		"improper 5xx handling",
		"other non-rfc complient",
		"other",
	], ],
);

# domain based checks, format the same as @bhlist

@domainbased = (
# abuse.net contacts
	["contacts.abuse.net", "Abuse.net Contacts", "www.abuse.net/",
		\&explain_txt, ],
# rfc-ignorant.org
	["dsn.rfc-ignorant.org", "rfc-ignorant dsn", 
		"rfc-ignorant.org/"],
	["postmaster.rfc-ignorant.org", "rfc-ignorant postmaster", 
		"rfc-ignorant.org/"],
	["abuse.rfc-ignorant.org", "rfc-ignorant abuse", 
		"rfc-ignorant.org/"],
	["whois.rfc-ignorant.org", "rfc-ignorant whois", 
		"rfc-ignorant.org/"],
# monkeys
#	["bandwith-pigs.monkeys.com", "Monkeys.com bandwidth pigs",
#		"www.monkeys.com/bandwidth-pigs/",],
# dnsbl.org
	["in.dnsbl.org", "DNSBL.org", "www.dnsbl.org/", \&explain_iterate, [
		"",
		"",	
		"UCE",
		"Fraud",
		"Promotes spamware",
		"illegal content",
		"bad mailing list",
		]],
	["ex.dnsbl.org", "ex.DNSBL.org", "www.dnsbl.org/ex.dnsbl.php3",
		\&explain_iterate, [
			"",
			"Sapient Fridges spamsites",
			"easydns mailhubs",
		]],
# deadbeef
	["bl.deadbeef.com", "deadbeef", "spam.deadbeef.com/bl/", ],
# mailpolice
	["bulk.rhs.mailpolice.com", "mailpolice", "rhs.mailpolice.com", ],
);
