#include "html.h"
#ifndef __errorh__
  #include "error.h"
#endif
#ifndef __parammaph__
  #include "parammap.h"
#endif

void HTML::CheckExpandable(){
  m_isExpandable=(int)m_content.find('}',0)!=-1;
}

void HTML::UpdateCache(){
  m_tagName=m_content;
  m_tagName.erase(find(m_tagName.begin(),m_tagName.end(),' '),m_tagName.end());
  m_token=TokenMap::NameToTokenNum(m_tagName);
  m_firstChar=m_tagName[0];
}

string HTML::Print()const{
  if(m_isMarkup) return "<"+m_content+">"; else return m_content;
}

/*ostream& operator<<(ostream& out,const HTML& what){
  out<<what.Print();
  return out;
}*/

HTML& HTML::operator=(const HTML& original){
//  if(&original!=this){
    m_isMarkup=original.m_isMarkup;
    m_preformat=original.m_preformat;
    m_content=original.m_content;
    m_myPair=NULL;
    m_myElse=NULL;
    m_fname=original.m_fname;
    m_line=original.m_line;
    m_tagName=original.m_tagName;
    m_firstChar=original.m_firstChar;
    m_token=original.m_token;
//  }
  return *this;
}

void HTML::BuildParamMap(ParamMap& paramMap)const{
  string::const_iterator sep=(string::const_iterator)NULL,param=(string::const_iterator)NULL,endpos=m_content.end();
  string::const_iterator startpos=find(m_content.begin(),endpos,' ');
  if (startpos != m_content.end()) ++startpos;
  while (startpos != m_content.end()) {
    endpos = m_content.end();
    sep = find(startpos,endpos,' ');
    sep = find(startpos,sep,'=');
    if ((sep != m_content.end())&& (*sep == '=')){
      // we found an equals. endpos is invalid (might be a quoted space)
      param=sep+1;
      //++param;
      if (param == m_content.end()) {
        Warn(*this,"Badly formed parameter value");
        return;
      }
      char quote = *param;
      if ((quote != '"') && (quote !='\'')) {
        //its not quoted
        quote=' ';
      } else {
        ++param;
        if (param == m_content.end()) {
          Warn(*this,"Badly formed parameter value");
          return;
        }
      }
      endpos = find(param,m_content.end(),quote);
      string name(startpos,sep);
      if(!g_isXML) transform(name.begin(),name.end(),name.begin(),ToUpper());
      string value(param,endpos);
      paramMap[name]=value;
      if ((quote !=' ') && (endpos !=m_content.end())) ++endpos;
      startpos = endpos;
    } else {
      // no equals - so its a space or end of string
      string name(startpos,sep);
      if(!g_isXML) transform(name.begin(),name.end(),name.begin(),ToUpper());
      paramMap[name].erase();
      startpos=sep;
    }
    if (startpos!=m_content.end()) ++startpos;
  }
}

static inline int LastFind(const string &in){
  bool prevWasBrace=false;
  int pos=in.length()-1;
  for(string::const_reverse_iterator i=in.rbegin();i !=in.rend();++i) {
    if(prevWasBrace && (*i=='$')) return pos;
    prevWasBrace=(*i=='{');
    --pos;
  }
  return -1;
}

void HTML::ExpandVariablesEngine(const Vars& vars){
  int pos,taglen=m_tagName.length();
  bool sub=false;
  while((pos=LastFind(m_content))!=-1){
    int end=m_content.find('}',pos);
    if(end!=-1){
      if(pos<taglen) sub=true;
      string vName=m_content.substr(pos+2,end-pos-2),value;
      if(!vars.Get(*this,vName,value)) Error(*this,e_UndefVar,vName);
      m_content.replace(pos,end-pos+1,value);
    }else{
      Error(*this,e_RunOnVar);
    }
  }
  if(sub) UpdateCache();
}

void HTML::AppendToContent(const string& st){
  m_content+=st;
  UpdateCache();
}

void HTML::DropFirstChar(){
  m_content=m_content.substr(1,string::npos);
  UpdateCache();
}
