#ifndef __navstoreh__
#define __navstoreh__

#ifndef __htmlstreamh__
  #include "htmlstream.h"
#endif
#ifndef __tokenmaph__
  #include "tokenmap.h"
#endif

#include <list>
#include <string>

class Nav;
class ParamMap;

class NavStore {
public:
  NavStore(): m_title(),m_url(),m_children(),m_countkids(0),m_open(false),m_selected(false),m_levels(0) {}
  NavStore(const string& title,const string& url): m_title(title),m_url(url),m_children(),m_countkids(0),
    m_open(false),m_selected(false),m_levels(0) {}
private:
  string m_title;
  string m_url;
  list<NavStore> m_children;
  int m_countkids;
  bool m_open;
  bool m_selected;
  int m_levels;
  void DefaultOpenPre(HTMLStream& stream,HTMLStream::iterator Cur,int level);
  void DefaultOpenEntry(HTMLStream& stream,HTMLStream::iterator Cur,int level,bool last);
  void DefaultOpenPost(HTMLStream& stream,HTMLStream::iterator Cur,int level);
  void DefaultFlatPre(HTMLStream& stream,HTMLStream::iterator Cur,int level);
  void DefaultFlatEntry(HTMLStream& stream,HTMLStream::iterator Cur,int level,bool last);
  void DefaultFlatPost(HTMLStream& stream,HTMLStream::iterator Cur,int level);
public:
  enum OutputFormat {of_flat,of_folded,of_open};
  void addtolevel(HTMLStream::iterator cur,int level,const string& title,const string& value);
  bool verify(HTMLStream::iterator Cur,const string& buildfile,OutputFormat format);
  void DoOpen(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,TokenMap::Token preToken,TokenMap::Token entryToken,TokenMap::Token postToken,int from=0,int to=-1,int highest=0,int level=0);
  void DoFlat(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,TokenMap::Token preToken,TokenMap::Token entryToken,TokenMap::Token postToken,int from=0,int to=-1,int highest=0,int level=0);
};

#endif
