/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: HydrogenApp.h,v 1.37 2004/06/07 12:38:37 comix Exp $
 *
 */
#ifndef HYDROGEN_APP_H
#define HYDROGEN_APP_H


#include <iostream>
#include "qstatusbar.h"
#include "qfiledialog.h"
#include "qapplication.h"
#include "qmessagebox.h"

#include "lib/Object.h"
#include "lib/Song.h"
#include "lib/EngineListener.h"

class PatternEditorPanel;
class MainForm;
class Mixer;
class SongEditor;
class SongEditorPanel;
class MixerLine;
class AudioEngineInfoForm;
class HelpBrowser;
class DrumkitManager;
class LadspaFXProperties;
class PlayerControl;
class InstrumentPropertiesDialog;

static const int H2_TEXT_EVENT = QEvent::User + 5780;

class H2TextEvent : public QCustomEvent 
{
	public:
		H2TextEvent(QString newText) : QCustomEvent( H2_TEXT_EVENT ) {
			text = newText;
		}

		H2TextEvent(QString newText, QString errorMsg ) : QCustomEvent( H2_TEXT_EVENT ) {
			text = newText;
			this->errorMsg = errorMsg;
		}

		/** Used for noteOn event */
		H2TextEvent(QString newText, Note *newNote) : QCustomEvent( H2_TEXT_EVENT ) {
			text = newText;
			note = newNote;
		}

		QString getText() {	return text;	}

		/** Used in noteOn event */
		Note* getNote() {	return note;	}

		QString getErrorMsg() {	return errorMsg;	}
	
	private:
		QString text;

		/** Used in EngineError event */
		QString errorMsg;

		/** Used in noteOn event */
		Note *note;
};



class HydrogenApp : public EngineListener, public Object
{
	public:
		HydrogenApp( MainForm* pMainForm, Song *pFirstSong );

		/// Returns the instance of HydrogenApp class
		static HydrogenApp* getInstance();

		virtual ~HydrogenApp();

		void setSong(Song* pSong);
		Song *getSong();

		void showPreferencesDialog();
		void showMixer(bool bShow);
		void showAudioEngineInfoForm();

		Mixer* getMixer() {	return m_pMixer;	}
		MainForm* getMainForm() {	return m_pMainForm;	}
		SongEditorPanel* getSongEditorPanel() {	return m_pSongEditorPanel;	}
		AudioEngineInfoForm* getAudioEngineInfoForm() {	return m_pAudioEngineInfoForm;	}
		HelpBrowser* getHelpBrowser() {	return m_pHelpBrowser;	}
		DrumkitManager* getDrumkitManager() {	return m_pDrumkitManager;	}
		PatternEditorPanel* getPatternEditorPanel() {	return m_pPatternEditorPanel;	}
		LadspaFXProperties* getLadspaFXProperties(uint nFX) {	return m_pLadspaFXProperties[nFX];	}
		InstrumentPropertiesDialog* getInstrumentProperties() {	return m_pInstrumentProperties;	}
		PlayerControl* getPlayerControl() {	return m_pPlayerControl;	}
				
		void setStatusBarMessage(QString msg, int msec = 0);

		//void loadNewInstrument(int instrNumber);

		vector<LadspaFXInfo*> getPluginList() {	return m_pluginList;	}
		LadspaFXGroup* getFXRootGroup() { return m_pFXRootGroup;	}

	private:
		static HydrogenApp *m_pInstance;	///< HydrogenApp instance

		QStatusBar *m_pStatusBar;
		MainForm *m_pMainForm;
		Mixer *m_pMixer;
		PatternEditorPanel* m_pPatternEditorPanel;
		AudioEngineInfoForm *m_pAudioEngineInfoForm;
		SongEditorPanel *m_pSongEditorPanel;
		HelpBrowser *m_pHelpBrowser;
		DrumkitManager *m_pDrumkitManager;
		vector<LadspaFXInfo*> m_pluginList;
		InstrumentPropertiesDialog* m_pInstrumentProperties;
		PlayerControl *m_pPlayerControl;

		LadspaFXProperties *m_pLadspaFXProperties[MAX_FX];
		LadspaFXGroup *m_pFXRootGroup;

		// implement EngineListener interface
		void engineError(uint nErrorCode);

		void setupTopLevelInterface(); 
		void setupMDIInterface();
		void setupSinglePanedInterface();
};



#endif
