/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: InstrumentPropertiesDialog.h,v 1.12 2004/07/09 16:22:07 comix Exp $
 *
 */

#ifndef INSTRUMENT_PROPERTIES_DIALOG_H
#define INSTRUMENT_PROPERTIES_DIALOG_H

#include "qtimer.h"

#include "InstrumentPropertiesDialog_UI.h"
#include "MixerLine.h"

#include "Object.h"
#include "EngineListener.h"

///
/// Instrument Properties Dialog
///
class InstrumentPropertiesDialog : public InstrumentPropertiesDialog_UI, public Object, public EngineListener
{
	Q_OBJECT
	
	public:
		InstrumentPropertiesDialog( QWidget* parent );
		~InstrumentPropertiesDialog();
		
	public slots:
		void updatePeak();

		void nameClicked(MixerLine* ref);
		void noteOnClicked(MixerLine* ref);
		void noteOffClicked(MixerLine* ref);
		void muteClicked(MixerLine* ref);
		void soloClicked(MixerLine* ref);
		void volumeChanged(MixerLine* ref);
		void panChanged(MixerLine* ref);
		void knobChanged(MixerLine* ref, int nKnob);

	
	private:
		QTimer *m_pTimer;	///< used for instrument peak update
		MixerLine *m_pMixerLine;
		Instrument *m_pInstrument;
		
		// implements EngineListener interface
		virtual void selectedInstrumentChanged();
		//~ implements EngineListener interface

		virtual void layerSelected();
		virtual void browseBtnClicked();
		virtual void minValueChanged();
		virtual void maxValueChanged();
		virtual void gainValueChanged();
		virtual void pitchValueChanged();
		virtual void playLayerBtnClicked();
		virtual void deleteBtnClicked();
};

#endif


