/* time64.h - Complete time: microseconds and seconds condensed into an int64_t
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#ifndef COMMON_TIME64_H
#define COMMON_TIME64_H

#include <stdint.h>
#include <sys/time.h>

#define MICROS_PER_SEC	1000000LL

extern inline int64_t
time64_seconds(int64_t time)
{
	return time / MICROS_PER_SEC;
}

extern inline int32_t
time64_microseconds(int64_t time)
{
	return time % MICROS_PER_SEC;
}

extern inline int64_t
time64_from_timeval(struct timeval *tv)
{
	return tv->tv_sec * MICROS_PER_SEC + tv->tv_usec;
}

extern inline void
time64_to_timeval(struct timeval *tv, int64_t time)
{
	tv->tv_sec = time / MICROS_PER_SEC;
	tv->tv_usec = time % MICROS_PER_SEC;
}

extern inline int64_t
time64_now(void)
{
	struct timeval tv;
	if (gettimeofday(&tv, (struct timezone *) 0) < 0)
		return 0LL;
	return time64_from_timeval(&tv);
}

#endif
