/* vim:tabstop=4:expandtab:shiftwidth=4
 * 
 * Idesk -- XIconWithShadow.cpp
 *
 * Copyright (c) 2002, Chris (nikon) (nikon@sc.rr.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *      Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *      
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *      
 *      Neither the name of the <ORGANIZATION> nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * (See the included file COPYING / BSD )
 */

#include "XIconWithShadow.h"
#include "XPngImage.h"
#include "SimpleSvgImage.h"

XIconWithShadow::XIconWithShadow(AbstractContainer * cont, AbstractConfig * con,
              AbstractIconConfig * iConfig)
                : XIcon(cont, con, iConfig)
{   
    DesktopIconConfig * dIcon = dynamic_cast<DesktopIconConfig *>(iconConfig);

    if (dIcon->isSvg())
        shadowImage = new SimpleSvgImageShadow(cont, this, config, iconConfig);
    else if (dIcon->isPng())
        shadowImage = new XPngImageShadow(cont, this, config, iconConfig);
    //else if (dIcon->isXpm())
        //
    else
    {
        cout << "Unknown file format: \n";
        // implement way to skip icon and not segfault
    }

    shadowImage->configure();
    shadowImage->createWindow();
    shadowImage->lowerWindow();
    
    shadowVisible = false;
}

XIconWithShadow::~XIconWithShadow()
{
    delete shadowImage;
}

void XIconWithShadow::dragMotionNotify(XEvent ev)
{
    snapShadow();
    XIcon::dragMotionNotify(ev);
}

void XIconWithShadow::snapShadow()
{
    int tempX, tempY;

    if (shadowVisible)
    {
        tempX = x;
        tempY = y;

        findSnapPosition(tempX, tempY);
        fixPosition(tempX, tempY);

        if (tempX != shadowX || tempY != shadowY)
        {
            shadowX = tempX;
            shadowY = tempY;

            shadowImage->moveWindow(shadowX, shadowY);
            shadowImage->refreshIcon();
        }
    }
    else 
    {
        shadowVisible = true;
        shadowX = x;
        shadowY = y;

        findSnapPosition(shadowX, shadowY);
        fixPosition(shadowX, shadowY);

        shadowImage->moveWindow(shadowX, shadowY);
        shadowImage->mapWindow();
        shadowImage->refreshIcon();
    }
}

void XIconWithShadow::dragButtonRelease(XEvent ev)
{
    XIcon::dragButtonRelease(ev);
    shadowImage->unmapWindow();

    shadowVisible = false;
}

void XIconWithShadow::lowerIcon()
{
    XIdeskImage * xImage = dynamic_cast<XIdeskImage *>(image);
    xImage->lowerWindow();

    if (captionOn)
    {
        XCaption * xCaption = dynamic_cast<XCaption *>(caption);
        xCaption->lowerWindow();
    }
    shadowImage->lowerWindow();
}

void XIconWithShadow::findSnapPosition(int &xCord, int &yCord)
{   
    DesktopConfig * dConfig =
            dynamic_cast<DesktopConfig *>(config);
    XDesktopContainer * xContainer =
            dynamic_cast<XDesktopContainer *>(container);

    if (!dConfig->getStartSnapLeft())
        xCord = xContainer->widthOfScreen() - xCord;
    if (!dConfig->getStartSnapTop())
        yCord = xContainer->heightOfScreen() - yCord;

    int xMid = xCord + image->getWidth()/2;
    int yMid = yCord + image->getHeight()/2;

    xCord = xMid - xMid % (dConfig->getSnapWidth());
    yCord = yMid - yMid % (dConfig->getSnapHeight());

    xCord += dConfig->getSnapWidth()/2 - image->getWidth()/2;
    yCord += dConfig->getSnapHeight()/2 - image->getHeight()/2;

    if (!dConfig->getStartSnapLeft())
        xCord = xContainer->widthOfScreen() - xCord;
    if (!dConfig->getStartSnapTop())
        yCord = xContainer->heightOfScreen() - yCord;
}

void XIconWithShadow::renderShadowToImage(Pixmap &buffer, int fX, int fY)
{
    shadowImage->renderShadowToImage(buffer, fX, fY);
}
